<?php
$settings = \App\Models\GeneralSetting::find(1);
?>
<?php $__env->startSection('meta-content'); ?>

<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="<?php if($settings): ?><?php echo e($settings->meta_desc); ?><?php endif; ?>">
<meta name="tags" content="<?php if($settings): ?><?php echo e($settings->meta_tags); ?><?php endif; ?>">
<meta name="keywords" content="<?php if($settings): ?><?php echo e($settings->meta_keywords); ?><?php endif; ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="flex flex-wrap justify-center leading-normal w-full">
  <div class="container flex flex-col items-center px-2 py-6 md:px-0 md:py-8">
      <h2 class="text-lg uppercase">Our Top Picks</h2>
      <p class="font-light text-center mb-8">Thuroughly tested and evaluated by our expert editors to help you make a more informed buying decision.</p>
      <div class="flex flex-wrap justify-center mb-8">
         <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
         <a href="<?php echo e(route('single-category',$category->slug)); ?>" class="flex flex-col flex-1 items-center no-underline px-16 py-4">
            <img class="h-16 w-16 flex items-center justify-center" src="<?php echo e(asset('backend-asset/images/category')); ?>/<?php echo e($category->feature_image); ?>" alt="<?php echo e($category->name); ?>">
             
            <p class="text-center text-sm text-black pt-1"><?php echo e($category->name); ?></p>
         </a>
         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
   </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\couponsbaskets\resources\views/frontend/pages/categories.blade.php ENDPATH**/ ?>