<?php
$settings = \App\Models\GeneralSetting::find(1);
?>
<?php $__env->startSection('meta-content'); ?>

<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="<?php if($settings): ?><?php echo e($settings->meta_desc); ?><?php endif; ?>">
<meta name="tags" content="<?php if($settings): ?><?php echo e($settings->meta_tags); ?><?php endif; ?>">
<meta name="keywords" content="<?php if($settings): ?><?php echo e($settings->meta_keywords); ?><?php endif; ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="flex flex-wrap justify-center leading-normal w-full">
      <div class="container px-2 py-4 md:px-0">
         <h3 class="text-center text-black uppercase mb-4">All Blogs</h3>
         <div class="flex flex-col md:flex-row">
            <div class="w-full">
               <div class="flex flex-wrap md:ml-3">
                  <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <article class="w-1/4 mb-2 md:mb-6">
                     <div class="overflow-hidden rounded-sm shadow h-full mr-1 md:mr-3">
                        <a href="<?php echo e(route('frontend-single-blog',$blog->slug)); ?>" class="block bg-white text-black no-underline h-full text-sm">
                           <img src="<?php echo e(asset('backend-asset/images/blog')); ?>/<?php echo e($blog->featured_image); ?>" alt="<?php echo e($blog->title); ?>"> 
                           <div class="p-4 pt-2">
                              <h3 class="text-base font-semibold md:text-xl"><?php echo e($blog->title); ?></h3>
                             
                           </div>
                        </a>
                     </div>
                  </article>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   
               </div>
               <?php echo e($blogs->links()); ?>

            </div>
           
         </div>
      </div>
   </div>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\couponsbaskets\resources\views/frontend/pages/blogs.blade.php ENDPATH**/ ?>