<?php
$settings = \App\Models\GeneralSetting::find(1);
?>
<?php $__env->startSection('meta-content'); ?>

<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="<?php if($settings): ?><?php echo e($settings->meta_desc); ?><?php endif; ?>">
<meta name="tags" content="<?php if($settings): ?><?php echo e($settings->meta_tags); ?><?php endif; ?>">
<meta name="keywords" content="<?php if($settings): ?><?php echo e($settings->meta_keywords); ?><?php endif; ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="flex flex-wrap justify-center leading-normal w-full">
    <div class="container px-2 py-4 md:py-8 md:px-0">
      <div class="flex flex-col items-center">
         <h3 class="text-center uppercase w-full mb-4">Popular Stores</h3>
         <div class="flex flex-wrap w-full -mx-1 md:-mx-3">
            <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <article class="w-1/2 mb-4 md:w-1/4 md:mb-0 py-4">
               <div class="overflow-hidden rounded-sm shadow h-full mx-1 md:mx-3">
                  <div class="flex flex-col items-center bg-white text-black no-underline h-full">
                     <div class="flex justify-center items-center flex-grow">
                     <a href="<?php echo e(route('store-profile',$row->slug)); ?>">
                       <img src="<?php echo e(asset('backend-asset/images/store')); ?>/<?php echo e($row->featured_image); ?>" alt="<?php echo e($row->name); ?>" class="w-full"></div>
                     <div class="p-4 pt-2">
                        <h4 class="text-base font-semibold"><?php echo e($row->name); ?> </h4>
                        <p class="hidden font-light md:block" style="overflow: hidden;text-overflow: ellipsis;display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical;"> <?php echo e($row->description); ?></p>
                     </div>
                     </a>
                     
               </div>
            </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
         </div>
         <?php echo e($stores->links()); ?>

      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('frontend.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\couponsbaskets\resources\views/frontend/pages/store.blade.php ENDPATH**/ ?>