<?php


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/','App\Http\Controllers\Frontend\HomeController@index')->name('index');
Route::get('/search-global','App\Http\Controllers\Frontend\HomeController@global_search')->name('global_search');
Route::group(['prefix' => '/auth'],function(){
	Route::get('/login','App\Http\Controllers\Auth\AccountsController@loginView')->name('login');
	Route::get('/signup','App\Http\Controllers\Auth\AccountsController@signupView')->name('signup');
	Route::get('/logout','App\Http\Controllers\Auth\AccountsController@logout')->name('logout');

	Route::post('/login-data','App\Http\Controllers\Auth\AccountsController@login')->name('login-data');
	
	Route::get('/our-company','App\Http\Controllers\Frontend\HomeController@Ourcompany')->name('our-company');
	Route::get('/privacy-policy','App\Http\Controllers\Frontend\HomeController@privacyPolicyView')->name('privacy-policy');
	Route::get('/terms-and-condition','App\Http\Controllers\Frontend\HomeController@termConditionView')->name('terms-and-condition');

});


// Route::group(['prefix' => 'main'],function(){
	Route::get('/','App\Http\Controllers\Frontend\HomeController@index')->name('frontend-index');
	Route::get('/coupons','App\Http\Controllers\Frontend\HomeController@coupons')->name('frontend-coupons');
	Route::get('/search-coupons','App\Http\Controllers\Frontend\HomeController@search_coupons')->name('search_coupons');
// 	Route::get('/merchants','App\Http\Controllers\Frontend\HomeController@stores')->name('frontend-stores');
	Route::get('/search-stores','App\Http\Controllers\Frontend\HomeController@search_stores')->name('search_stores');
	Route::get('/categories','App\Http\Controllers\Frontend\HomeController@categories')->name('frontend-categories');

	Route::get('/store-profile/{slug}','App\Http\Controllers\Frontend\HomeController@storeProfile')->name('store-profile');
	Route::get('/single-category/{slug}','App\Http\Controllers\Frontend\HomeController@singleCategory')->name('single-category');

	Route::get('/blogs','App\Http\Controllers\Frontend\HomeController@blogs')->name('frontend-blogs');
	Route::get('/single-blog/{slug}','App\Http\Controllers\Frontend\HomeController@singleBlog')->name('frontend-single-blog');

	Route::post('/email-subscription-post','App\Http\Controllers\Frontend\HomeController@emailSubscription')->name('email-subscription-post');
	Route::get('/update_coupon_used','App\Http\Controllers\Frontend\HomeController@update_coupon_used')->name('update_coupon_used');
	Route::post('/post_comment','App\Http\Controllers\Frontend\HomeController@post_comment')->name('post_comment');
	Route::get('/exclusivecoupons','App\Http\Controllers\Frontend\HomeController@exclusivecoupons')->name('exclusive-coupons');
	Route::get('/events/{id}','App\Http\Controllers\Frontend\HomeController@eventcoupons')->name('events');
	Route::get('/sitemap','App\Http\Controllers\Frontend\HomeController@Sitemap')->name('sitemap');
	Route::get('/info/{slug}','App\Http\Controllers\Frontend\HomeController@Page')->name('info');
    

	
// });

Route::group(['prefix' => '/backend'],function(){
	Route::get('/','App\Http\Controllers\Backend\HomeController@index')->name('backend-index');
	Route::get('/email-subscriptions','App\Http\Controllers\Backend\HomeController@emailSubscriptionView')->name('email-subscriptions');
	Route::get('/site-content','App\Http\Controllers\Backend\HomeController@sitecontent')->name('site-content');
	Route::post('/add-site-content','App\Http\Controllers\Backend\HomeController@Addsitecontent')->name('add-site-content');
});

Route::group(['prefix' => '/backend/category'],function(){
	Route::get('/','App\Http\Controllers\Backend\CategoryController@categoryView')->name('category');
	Route::post('/add-category','App\Http\Controllers\Backend\CategoryController@categoryAdd')->name('add-category');
	Route::get('/edit-category/{id}','App\Http\Controllers\Backend\CategoryController@editCategoryView')->name('edit-category');
	Route::post('/edit-category-post','App\Http\Controllers\Backend\CategoryController@editCategoryPost')->name('edit-category-post');

	Route::get('/delete-category/{id}','App\Http\Controllers\Backend\CategoryController@deleteCategory')->name('delete-category');
	
});

Route::group(['prefix' => '/backend/sub-category'],function(){
	Route::get('/','App\Http\Controllers\Backend\SubcategoryController@subCategoryView')->name('sub-category');
	Route::post('/add-sub-category','App\Http\Controllers\Backend\SubcategoryController@subCategoryAdd')->name('add-sub-category');

	Route::get('/edit-sub-category/{id}','App\Http\Controllers\Backend\SubcategoryController@editSubCategoryView')->name('edit-sub-category');
	Route::post('/edit-sub-category-post','App\Http\Controllers\Backend\SubcategoryController@editSubCategoryPost')->name('edit-sub-category-post');

	Route::get('/delete-sub-category/{id}','App\Http\Controllers\Backend\SubcategoryController@deleteSubCategory')->name('delete-sub-category');	
});

Route::group(['prefix' => '/backend/stores'],function(){
	Route::get('/','App\Http\Controllers\Backend\StoreController@storeView')->name('stores');
	Route::get('/add-store','App\Http\Controllers\Backend\StoreController@addStoreView')->name('add-store');
	Route::post('/add-store-post','App\Http\Controllers\Backend\StoreController@addStore')->name('add-store-post');

	Route::get('/edit-store/{id}','App\Http\Controllers\Backend\StoreController@editStoreView')->name('edit-store');
	Route::get('/coupons/{id}','App\Http\Controllers\Backend\StoreController@coupons')->name('store_coupon');
	Route::post('/edit-store-post','App\Http\Controllers\Backend\StoreController@editStorePost')->name('edit-store-post');
	
    Route::post('/update-order','App\Http\Controllers\Backend\StoreController@update_order')->name('update_order');
	Route::get('/delete-store/{id}','App\Http\Controllers\Backend\StoreController@deleteStore')->name('delete-store');	
});

Route::group(['prefix' => '/backend/coupons'],function(){
	Route::get('/','App\Http\Controllers\Backend\CouponController@couponView')->name('coupons');
	Route::get('/add-coupon','App\Http\Controllers\Backend\CouponController@addCouponView')->name('add-coupon');
	Route::get('/sub-category-api','App\Http\Controllers\Backend\CouponController@subCategoryApi')->name('sub-category-api');

	Route::post('/add-coupon-post','App\Http\Controllers\Backend\CouponController@addCoupon')->name('add-coupon-post');
	Route::get('/delete-coupon/{id}','App\Http\Controllers\Backend\CouponController@deleteCoupon')->name('delete-coupon');
	
	Route::get('/edit-coupon/{id}','App\Http\Controllers\Backend\CouponController@editCouponView')->name('edit-coupon');
	Route::post('/edit-coupon-post','App\Http\Controllers\Backend\CouponController@editCouponPost')->name('edit-coupon-post');

	Route::get('/check_sorting_order','App\Http\Controllers\Backend\CouponController@check_sorting_order')->name('check_sorting_order');
	

});

Route::group(['prefix' => '/backend/banner'],function(){
	Route::get('/','App\Http\Controllers\Backend\BannerController@bannerView')->name('banner-view');
	Route::post('/banner-update','App\Http\Controllers\Backend\BannerController@addBanner')->name('banner-update');
	Route::get('/delete-banner/{id}','App\Http\Controllers\Backend\BannerController@Delbanner')->name('delete-banner');
});

Route::group(['prefix' => '/backend/pages'],function(){
	Route::get('/','App\Http\Controllers\Backend\PageController@index')->name('pages');
	Route::get('/add-new-page','App\Http\Controllers\Backend\PageController@create')->name('add-page-view');
	Route::post('/add-page','App\Http\Controllers\Backend\PageController@store')->name('add-page');
	Route::get('/update-page-view/{id}','App\Http\Controllers\Backend\PageController@edit')->name('edit-page-view');
	Route::get('/delete-page/{id}','App\Http\Controllers\Backend\PageController@destroy')->name('delete-page');
	Route::post('/update-page','App\Http\Controllers\Backend\PageController@update')->name('update-page');
});

Route::group(['prefix' => '/backend/blogs'],function(){
	Route::get('/','App\Http\Controllers\Backend\BlogController@blogView')->name('blogs');
	Route::get('/comments','App\Http\Controllers\Backend\BlogController@blog_comments')->name('blog_comments');
	Route::get('/approve/{id}','App\Http\Controllers\Backend\BlogController@approve')->name('approve');
	Route::get('/add-blog','App\Http\Controllers\Backend\BlogController@addBlogView')->name('add-blog');
	Route::post('/add-blog-post','App\Http\Controllers\Backend\BlogController@addBlogPost')->name('add-blog-post');

	Route::get('/edit-blog/{id}','App\Http\Controllers\Backend\BlogController@editBlogView')->name('edit-blog');
	Route::post('/edit-blog-post','App\Http\Controllers\Backend\BlogController@editBlogPost')->name('edit-blog-post');

	Route::get('/delete-blog/{id}','App\Http\Controllers\Backend\BlogController@deleteBlog')->name('delete-blog');	
});



Route::group(['prefix' => '/backend/events'],function(){
	Route::get('/','App\Http\Controllers\Backend\EventController@index')->name('event-view');
	Route::post('/add-event-post','App\Http\Controllers\Backend\EventController@addevent')->name('add-event-post');

	Route::get('/list','App\Http\Controllers\Backend\EventController@eventView')->name('event-list');

	Route::get('/edit-event/{id}','App\Http\Controllers\Backend\EventController@editEventView')->name('edit-event');
	Route::post('/edit-event-post','App\Http\Controllers\Backend\EventController@editEventPost')->name('edit-event-post');
});

Route::group(['prefix' => '/backend/settings'],function(){
  Route::get('/site-settings','App\Http\Controllers\Backend\SettingController@SiteSetting')->name('add.settings');
  Route::post('/store-settings','App\Http\Controllers\Backend\SettingController@storeSetting')->name('store.settings');
  Route::post('/update-settings','App\Http\Controllers\Backend\SettingController@UpdateSetting')->name('update.settings');
});

Route::get('get-stores','App\Http\Controllers\Frontend\HomeController@getstores')->name('get-stores');


Route::get('get-coupons','App\Http\Controllers\Backend\CouponController@getcoupons')->name('get-coupons');
