@extends('frontend.layout.master') 
@section('meta-content')
<meta  name="title" content="{{$store->meta_title}}" />
<meta  name="description" content="{{$store->meta_description}}" />
<meta property="og:url" content="{{url()->current()}}" />
<meta property="og:site_name" content="Coupons Baskets" />
<meta name="csrf-token" content="{{ csrf_token() }}" />
@endsection
@section('content')
<div class="flex flex-wrap justify-center leading-normal w-full">
   <section class="under-header">
      <div class="container mx-auto flex-container-top px-0 sm:px-8 md:px-8 lg:px-8 xl:px-8">
         <div class="section-left">
            <h2 class="under-header-h-two">{{$store->name}}</h2>
            <p class="section-left-text">{{$store->description}}</p>
            {{-- <div class="under-header-btn-container"><a id="label-type" onclick="toggleType('')" class="btn-round">All Deals</a> <a id="label-type" onclick="toggleType('coupon')" class="btn-round">3 Coupons</a> <a id="label-type" onclick="toggleType('free-shipping')" class="btn-round">2 Free Shipping</a></div> --}}
         </div>
         <div class="section-right"><a href="javascript:;"><img src="{{ asset('backend-asset/images/store') }}/{{ $store->featured_image }}" alt="{{$store->name}}"></a></div>
      </div>
   </section>
   <section class="body-content">
      <div class="container mx-auto flex-container px-0 sm:px-8 md:px-8 lg:px-8 xl:px-8">
         <div class="section-left-body">
            @foreach($coupons as $row)
            <div  class="coupon-card-deals shadow relative ">
               
               <div class="coupon-card-left">
                 <img src="{{ asset('backend-asset/images/store') }}/{{ $store->featured_image }}" alt="{{$store->name}}" width="50">
                  <p class="coupon-card-left-tag">{{$row->type}}  </p>
               </div>
               <div class="coupon-card-right">
                  <div class="coupon-card-right-zero">
                    
                        <strong>
                           <p> {{$row->title}}   </p>
                        </strong>
                     <p> {{$row->description}}   </p>
                     <div class="coupon-card-tags">
                        <p id="coupon-card-tags-item-f" class="coupon-card-tags-item">{{$row->type}}  </p>
                        <p id="coupon-card-tags-item-v" class="coupon-card-tags-item">Verified</p>
                     </div>
                  </div>
                   @if($row->code == null)
                  <div class="coupon-card-right-one"><a href="{{ $row->url }}" target="_blank"  id="coupon-button" data-title="{{ $row->title }}" data-des="{{ $row->description }}" data-code="{{ $row->code }}" data-url="{{ $row->url }}" data-coupon_id="{{ $row->id }}"
                                       data-img="{{ asset('backend-asset/images/coupon') }}/{{ $row->featured_image }}"class="coupon-button-card-arrow"></a> <a href="{{ $row->url }}" target="_blank"  id="coupon-button" data-title="{{ $row->title }}" data-des="{{ $row->description }}" data-code="{{ $row->code }}" data-url="{{ $row->url }}" data-coupon_id="{{ $row->id }}"
                                       data-img="{{ asset('backend-asset/images/coupon') }}/{{ $row->featured_image }}"><button  class="bg-blue w-full rounded-sm text-white" style="height:3.5rem; font-size:13px">Get Deal</button></a></div>
                  @else
                  <div class="coupon-card-right-one">
                     <a href="{{ $row->url }}" target="_blank"  id="coupon-button" data-title="{{ $row->title }}" data-des="{{ $row->description }}" data-code="{{ $row->code }}" data-url="{{ $row->url }}" data-coupon_id="{{ $row->id }}"
                                       data-img="{{ asset('backend-asset/images/coupon') }}/{{ $row->featured_image }}" class="coupon-button-card-arrow"></a>
                     <a href="{{ $row->url }}" target="_blank"  id="coupon-button" data-title="{{ $row->title }}" data-des="{{ $row->description }}" data-code="{{ $row->code }}" data-url="{{ $row->url }}" data-coupon_id="{{ $row->id }}"
                                       data-img="{{ asset('backend-asset/images/coupon') }}/{{ $row->featured_image }}"><button  class="w-full bg-blue rounded-sm text-white" style="height:3.5rem; font-size:13px">Show Code</button></a></div>
                  @endif
               </div>
            </div>
            @endforeach
            
         </div>
         
   </section>
</div>

@endsection
@section('page-script')

  @if(url()->current() == 'https://contentstations.com/store-profile/viator-coupon-code')
    <!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=AW-11338562493">
</script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'AW-11338562493');
</script>

  @endif
@endsection