@extends('frontend.layout.master')

@php
$settings = \App\Models\GeneralSetting::find(1);
@endphp
@section('meta-content')

<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="@if($settings){{$settings->meta_desc}}@endif">
<meta name="tags" content="@if($settings){{$settings->meta_tags}}@endif">
<meta name="keywords" content="@if($settings){{$settings->meta_keywords}}@endif">
@endsection
@section('content')
<div class="flex flex-wrap justify-center leading-normal w-full">
    <div class="container px-2 py-4 md:py-8 md:px-0">
      <div class="flex flex-col items-center">
         <h3 class="text-center uppercase w-full mb-4">Popular Stores</h3>
         <div class="flex flex-wrap w-full -mx-1 md:-mx-3">
            @foreach($stores as $row)
            <article class="w-1/2 mb-4 md:w-1/4 md:mb-0 py-4">
               <div class="overflow-hidden rounded-sm shadow h-full mx-1 md:mx-3">
                  <div class="flex flex-col items-center bg-white text-black no-underline h-full">
                     <div class="flex justify-center items-center flex-grow">
                     <a href="{{ route('store-profile',$row->slug) }}">
                       <img src="{{ asset('backend-asset/images/store') }}/{{ $row->featured_image }}" alt="{{ $row->name }}" class="w-full"></div>
                     <div class="p-4 pt-2">
                        <h4 class="text-base font-semibold" style="color:#16404D">{{$row->name}} </h4>
                        <p class="hidden font-light md:block" style="overflow: hidden;text-overflow: ellipsis;display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical;color:#16404D"> {{$row->description}}</p>
                     </div>
                     </a>
                     
               </div>
            </article>
            @endforeach
         </div>
         {{$stores->links()}}
      </div>
    </div>
</div>
@endsection

