@extends('frontend.layout.master') 
@php
$settings = \App\Models\GeneralSetting::find(1);
@endphp
@section('meta-content')

<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="@if($settings){{$settings->meta_desc}}@endif">
<meta name="tags" content="@if($settings){{$settings->meta_tags}}@endif">
<meta name="keywords" content="@if($settings){{$settings->meta_keywords}}@endif">
@endsection
@section('content')
<div class="flex flex-wrap justify-center leading-normal w-full">
   <section class="under-header">
      <div class="container mx-auto flex-container-top px-0 sm:px-8 md:px-8 lg:px-8 xl:px-8">
         <div class="section-left">
            <h2 class="under-header-h-two">{{$cate->name}}</h2>
            <p class="section-left-text">{{$cate->description}}</p>
            {{-- <div class="under-header-btn-container"><a id="label-type" onclick="toggleType('')" class="btn-round">All Deals</a> <a id="label-type" onclick="toggleType('coupon')" class="btn-round">3 Coupons</a> <a id="label-type" onclick="toggleType('free-shipping')" class="btn-round">2 Free Shipping</a></div> --}}
         </div>
         <div class="section-right"><a href="javascript:;"><img src="{{ asset('backend-asset/images/category') }}/{{ $cate->feature_image }}" alt="{{$cate->name}}"></a></div>
      </div>
   </section>
   <section class="body-content">
      <div class="container mx-auto flex-container px-0 sm:px-8 md:px-8 lg:px-8 xl:px-8">
         <div class="section-left-body">
            @foreach($coupons as $row)
            <div  class="coupon-card-deals shadow relative ">
               <a href="/go/d/3404206" target="_blank" class="coupon-code-wrap w-full h-full absolute"></a> 
               <div class="coupon-card-left">
                  <p class="coupon-card-left-discount-amount"> {{$row->title}}   </p>
                  <p class="coupon-card-left-tag">{{$row->type}}  </p>
               </div>
               <div class="coupon-card-right">
                  <div class="coupon-card-right-zero">
                     <a href="/go/d/3404206" target="_blank" class="coupon-card-right-label">
                        <strong>
                           <p> {{$row->description}}   </p>
                        </strong>
                     </a>
                     <div class="coupon-card-tags">
                        <p id="coupon-card-tags-item-f" class="coupon-card-tags-item">{{$row->type}}  </p>
                        <p id="coupon-card-tags-item-v" class="coupon-card-tags-item">Verified</p>
                     </div>
                  </div>
                   @if($row->code == null)
                  <div class="coupon-card-right-one"><a href="{{ $row->url }}" target="_blank"  id="coupon-button" data-title="{{ $row->title }}" data-des="{{ $row->description }}" data-code="{{ $row->code }}" data-url="{{ $row->url }}" data-coupon_id="{{ $row->id }}"
                                       data-img="{{ asset('backend-asset/images/coupon') }}/{{ $row->featured_image }}"class="coupon-button-card-arrow">›</a> <a href="{{ $row->url }}" target="_blank"  id="coupon-button" data-title="{{ $row->title }}" data-des="{{ $row->description }}" data-code="{{ $row->code }}" data-url="{{ $row->url }}" data-coupon_id="{{ $row->id }}"
                                       data-img="{{ asset('backend-asset/images/coupon') }}/{{ $row->featured_image }}"><button id="coupon-button-card-get-offer" class="bg-blue w-full rounded-sm text-white p-2 h-10">Get Deal</button></a></div>
                  @else
                  <div class="coupon-card-right-one"><a href="{{ $row->url }}" target="_blank"  id="coupon-button" data-title="{{ $row->title }}" data-des="{{ $row->description }}" data-code="{{ $row->code }}" data-url="{{ $row->url }}" data-coupon_id="{{ $row->id }}"
                                       data-img="{{ asset('backend-asset/images/coupon') }}/{{ $row->featured_image }}" class="coupon-button-card-arrow">›</a> <a href="{{ $row->url }}" target="_blank"  id="coupon-button" data-title="{{ $row->title }}" data-des="{{ $row->description }}" data-code="{{ $row->code }}" data-url="{{ $row->url }}" data-coupon_id="{{ $row->id }}"
                                       data-img="{{ asset('backend-asset/images/coupon') }}/{{ $row->featured_image }}"><button id="coupon-button-card-get-offer" class="bg-blue w-full rounded-sm text-white p-2 h-10">Get Coupon</button></a></div>
                  @endif
               </div>
            </div>
            @endforeach
            
         </div>
         
   </section>
</div>
<div class="section bg">
   <div class="container">
      <div class="row">
         <div class="col-lg-12">
            <div class="store-profile">
               <div class="web_imagebox">
                  <img src="{{ asset('backend-asset/images/category') }}/{{ $cate->feature_image }}"  class="img-responsive" alt="{{ $cate->name }}">
               </div>
               <div class="store-info">
                  <h1 class="store-title">{{$cate->name}}</h1>
                  <div class="rating-stars">
                     <ul id="stars" data-store-id="354">
                        <li class="star " title="Poor" data-value="1">
                           <i class="fa fa-star"></i>
                        </li>
                        <li class="star " title="Fair" data-value="2">
                           <i class="fa fa-star"></i>
                        </li>
                        <li class="star " title="Good" data-value="3">
                           <i class="fa fa-star"></i>
                        </li>
                        <li class="star " title="Excellent" data-value="4">
                           <i class="fa fa-star"></i>
                        </li>
                        <li class="star " title="WOW!!!" data-value="5">
                           <i class="fa fa-star"></i>
                        </li>
                     </ul>
                     <p>
                     </p>
                  </div>
                  <div class="store-filteration">
                     <p>{{$cate->description}}</p>
                  </div>
               </div>
            </div>
            <!--<p class="sbmt-offer-btn"><i class="fa fa-tag"></i> Submit a Coupon</p>-->
         </div>
      </div>
   </div>
</div>
<div class="section bg noPadding sectionMarginResponsive">
   <div class="container">
      <div class="row">
         <div class="col-lg-12">
            <div class="store-breadcrumbs">
               <ul>
                  <li>Home</li>
                  <li><a href="javascript:void(0)"><i class="fa fa-angle-double-right"></i></a></li>
                  <li>Category Profile</li>
                  <li><i class="fa fa-angle-double-right"></i></a></li>
                  <li>{{$cate->slug}}</li>
               </ul>
            </div>
            <hr class="store-seperator">
         </div>
      </div>
   </div>
</div>
<div class="section bg noTopPadding">
   <div class="container">
      <div class="row">
         <div class="col-lg-12">
            <div class="store-wrapper">
               <div class="offers-wrapper single_store">
                   
                 @foreach($coupons as $row)
                  <div class="main-offer offer_single single_store_coupon active_coupon"  data-sort= "expired">
                     <div class="offer-wrapper">
                        <div class="main_wrapper">
                           <div class="offer-headline">
                              <div class="widgets">
                                 <span class="ribbon3"><span class="badge small">
                                 <i class="fa fa-tag"></i>  {{$row->type}}                    </span></span>
                              </div>
                              <h1 class="offer-title copycodebtn" data-id="" data-clipboard-text="">
                                 {{$row->title}}        
                              </h1>
                              <div class="widgets">
                                 <span class="badge verified-badge">
                                 <i class="fa fa-check-square-o"></i> Verified
                                 </span>
                              </div>
                              <div class="coupon-description">
                                 <p> {{$row->description}}    </p>
                              </div>
                              <!--<div class="widgets">-->
                              <!--   <span class="expired_date badge">-->
                              <!--   <img src="{{ asset('backend-asset/images/coupon') }}/{{ $row->featured_image }}" class="exp-icon" > 31, Mar          </span>-->
                              <!--</div>-->
                           </div>
                           <div class="sideactions">
                              <!--main_wraper-->
                              <a href="javascript:void(0)" class="copycodebtn"  data-id="" data-clipboard-text="">
                                 <div class="web_imagebox">
                                    <img data-src="{{ asset('backend-asset/images/coupon') }}/{{ $row->featured_image }}" class="img-responsive lazy" >
                                 </div>
                              </a>
                              @if($row->code == null)
                              <div class="action-box">
                                 <div class="copycodebtn action-code ">
                                    <a href="{{ $row->url }}" target="_blank"  id="coupon-button" data-title="{{ $row->title }}" data-des="{{ $row->description }}" data-code="{{ $row->code }}" data-url="{{ $row->url }}" data-coupon_id="{{ $row->id }}"
                                       data-img="{{ asset('backend-asset/images/coupon') }}/{{ $row->featured_image }}">
                                       <span class="js-offer-out">
                                       <span class="action-cta">Get Deal</span>
                                       </span>
                                       <div class="action-cta-code"> No Code Required  
                                          <span class="action-cta-peel"></span>
                                       </div>
                                    </a>
                                 </div>
                              </div>
                              @else
                              <div class="action-box">
                                 <div class="copycodebtn action-code ">
                                    <a href="{{ $row->url }}" target="_blank"  id="coupon-button" data-title="{{ $row->title }}" data-des="{{ $row->description }}" data-code="{{ $row->code }}" data-url="{{ $row->url }}" data-coupon_id="{{ $row->id }}"
                                       data-img="{{ asset('backend-asset/images/coupon') }}/{{ $row->featured_image }}">
                                       <span class="js-offer-out">
                                       <span class="action-cta">Get Coupon</span>
                                       </span>
                                       <div class="action-cta-code"> {{$row->code}} 
                                          <span class="action-cta-peel"></span>
                                       </div>
                                    </a>
                                 </div>
                              </div>
                              @endif
                           </div>
                        </div>
                     </div>
                     <!--offer_wrapper-->
                  </div>
                  <div class="likeandcomments" data-sort= "active">
                     <div class="icons-wrapper">
                        <!--<span class="likebtn likeOffer " data-id="37000" data-like="5">-->
                        <!--   <svg class="styles__ThumbsUp-sc-8tgwcx-0 cIfREJ" viewBox="0 0 16 16">-->
                        <!--      <path class="cls-1" d="M13.7 5.33h-2.37v-3A2.3 2.3 0 0 0 9 0H8a1.28 1.28 0 0 0-1.33 1.25c0 2.58-.6 4.3-1.45 4.47a3.3 3.3 0 0 0-1.13.44A1.16 1.16 0 0 0 3.5 6H1.17A1.17 1.17 0 0 0 0 7.17v7a1.17 1.17 0 0 0 1.17 1.17H3.5a1.16 1.16 0 0 0 .72-.25 5.9 5.9 0 0 0 3.4.9h6.08a2.3 2.3 0 0 0 2.3-2.3V7.85a2.5 2.5 0 0 0-2.3-2.52zm-12.37 2h2V14h-2zm13.34 6.37a1 1 0 0 1-1 1H7.62a4.12 4.12 0 0 1-3-.9V7.4c0-.05.2-.24.83-.37C7.5 6.6 8 3.7 8 1.33h1a1 1 0 0 1 1 1v3.2a1 1 0 0 0 1.13 1.13h2.57a1.18 1.18 0 0 1 1 1.2z"></path>-->
                        <!--   </svg>-->
                        <!--   <span class="txt">5 likes</span>-->
                        <!--</span> -->
                        <!--<span class="emailcoupon">-->
                        <!--   <div class="clickcmnt">-->
                        <!--      <i class="fa fa-clock-o"></i> <span class="txt">{{$row->end_date}}</span>-->
                        <!--   </div>-->
                        <!--</span>-->
                        <span class="likebtn">
                           <svg id="user" viewBox="0 0 32 32">
                              <path d="M22.56,16.53a9.95,9.95,0,0,1-13.12,0A15,15,0,0,0,1,30a1,1,0,0,0,1,1H30a1,1,0,0,0,1-1A15,15,0,0,0,22.56,16.53Z"/>
                              <circle cx="16" cy="9" r="8"/>
                           </svg>
                           <span class="txt">{{$row->total_use}} Uses</span>
                        </span>
                     </div>
                  </div>
                  <div class="section-seperator"></div>
                  @endforeach
               </div>
               <div class="store-sidebar">
                  
                  <div class="panel with-border similar-stores">
                     <h2 class="panel-title">Similar Stores</h2>
                     <div class="cubes-block">
                         @foreach($top_stores as $row)
                        <span class="single-cube">
                        <a href="{{ route('store-profile',$row->slug) }}">{{$row->name}}</a>
                        </span>
                        @endforeach
                     </div>
                  </div>
                  <div class="panel with-border related-categories">
                     <h2 class="panel-title">Popular Categories</h2>
                     <div class="cubes-block">
                         @foreach($category as $row)
                        <span class="single-cube">
                        <a href="{{ route('single-category',$row->slug) }}">{{$row->name}}</a>
                        </span>
                        @endforeach
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
@endsection
@section('page-script')
@endsection