@extends('frontend.layout.master')
@php
$settings = \App\Models\GeneralSetting::find(1);
@endphp
@section('meta-content')

<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="@if($settings){{$settings->meta_desc}}@endif">
<meta name="tags" content="@if($settings){{$settings->meta_tags}}@endif">
<meta name="keywords" content="@if($settings){{$settings->meta_keywords}}@endif">
 <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
     .blog-header {
            padding-bottom: 1.25rem;
            margin-bottom: 2rem;
            border-bottom: 1px solid #eee;
        }
        .blog-post {
            margin-bottom: 4rem;
        }
        .blog-post-title {
            margin-bottom: .25rem;
            font-size: 2.5rem;
        }
        .blog-post-meta {
            margin-bottom: 1.25rem;
            color: #727272;
        }
        .recent-post-item {
            display: flex;
            margin-bottom: 1rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid #eee;
        }
        .recent-post-item:last-child {
            border-bottom: none;
            margin-bottom: 0;
            padding-bottom: 0;
        }
        .recent-post-image {
            width: 80px;
            height: 60px;
            object-fit: cover;
            border-radius: 4px;
            margin-right: 15px;
        }
        .recent-post-title {
            font-size: 0.95rem;
            margin-bottom: 0.25rem;
            
        }
        .recent-post-title a {
            color:black;
        }
        .recent-post-title a:hover{
            color:black;
        }
        .recent-post-meta {
            font-size: 0.8rem;
            color: #6c757d;
        }
        
        /* Sidebar card styling */
        .sidebar-card {
            margin-bottom: 1.5rem;
            border: none;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        .sidebar-card .card-body {
            padding: 1.25rem;
        }
        .sidebar-card .card-title {
            font-size: 1.1rem;
            margin-bottom: 1rem;
            padding-bottom: 0.5rem;
            border-bottom: 1px solid #eee;
        }
        .featured-image {
            margin-bottom: 1.5rem;
            border-radius: .25rem;
            max-height: 400px;
            object-fit: cover;
        }
</style>
@endsection
@section('content')

 <div class="container">
        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb" class="mt-4">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item"><a href="#">Blog</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{$blog->slug}}</li>
            </ol>
        </nav>

        <div class="row">
            <!-- Main Content Area -->
            <div class="col-lg-8">
                <article class="blog-post">
                    <!-- Featured Image -->
                    <img src="{{ asset('backend-asset/images/blog') }}/{{ $blog->featured_image }}" alt="Blog post featured image" class="img-fluid featured-image">
                    
                    <!-- Title -->
                    <h1 class="blog-post-title">{{$blog->title}}</h1>
                    
                    <!-- Meta Info -->
                   
                    
                     {!! $blog->description !!}
                </article>

               
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <div class="position-sticky" style="top: 2rem;">
                    <!-- About Card -->
                   
                    <!-- Categories -->
                   

                      <div class="card sidebar-card">
                        <div class="card-body">
                            <h5 class="card-title">Recent Posts</h5>
                            @foreach($blogs as $row)
                            <div class="recent-post-item">
                                <img src="{{ asset('backend-asset/images/blog') }}/{{ $row->featured_image }}" alt="Post thumbnail" class="recent-post-image">
                                <div>
                                    <h6 class="recent-post-title"><a href="#">{{$row->title}}</a></h6>
                                    
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection