@extends('frontend.layout.master')
@php
$settings = \App\Models\GeneralSetting::find(1);
@endphp
@section('meta-content')

<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="@if($settings){{$settings->meta_desc}}@endif">
<meta name="tags" content="@if($settings){{$settings->meta_tags}}@endif">
<meta name="keywords" content="@if($settings){{$settings->meta_keywords}}@endif">
@endsection
@section('content')
<div class="flex flex-wrap justify-center leading-normal w-full">
   <section class="index-banner-sec">
   <div class="container-fluid p-0">
      <div class="slider-wrap">
         <div class="owl-carousel owl-theme banner-slider">
            @foreach($banner as $key => $row)
              
                  <div class="banner-slide">
                    
                        <img src="{{ asset('backend-asset/images/banner/' . $row->image) }}" alt="banner" class="img-fluid">
                   
                  </div>
              
               @endforeach        
         </div>
      </div>
   </div>	
</section>
   <div class="container flex flex-col items-center px-2 py-6 md:px-0 md:py-8">
      <h2 class="text-lg uppercase">Our Top Picks</h2>
      <p class="font-light text-center mb-8">Thuroughly tested and evaluated by our expert editors to help you make a more informed buying decision.</p>
      <div class="flex flex-wrap justify-center mb-8">
         @foreach($categories as $category)
         <a href="{{ route('single-category',$category->slug) }}" class="flex flex-col flex-1 items-center no-underline px-4">
            <img class="h-16 w-16 flex items-center justify-center" src="{{ asset('backend-asset/images/category') }}/{{ $category->feature_image }}" alt="{{ $category->name }}">
             
            <p class="text-center text-sm text-black pt-1">{{ $category->name }}</p>
         </a>
         @endforeach
      </div>
   </div>
   <div class="flex bg-grey-lighter justify-center w-full">
      <div class="container px-2 py-4 md:px-0">
         <h3 class="text-center text-black uppercase mb-4">Recent Blogs</h3>
         <div class="flex flex-col md:flex-row">
            @php
               $singleblog = $blogs->shift();
            @endphp
            <div class="w-full mb-2 md:w-1/2 md:mb-6">
               <div class="overflow-hidden rounded-sm shadow h-full md:mr-3">
                  <a href="{{route('frontend-single-blog',$singleblog->slug)}}" class="block bg-white text-black no-underline h-full ">
                     <img src="{{ asset('backend-asset/images/blog') }}/{{ $singleblog->featured_image }}" alt="{{ $singleblog->title }}"> 
                     <div class="p-4 pt-2">
                        <h3 class="text-base font-semibold md:text-xl">{{$singleblog->title}}</h3>
                        
                     </div>
                     <div style="overflow: hidden;text-overflow: ellipsis;display: -webkit-box; -webkit-line-clamp: 5; -webkit-box-orient: vertical;">{!!$singleblog->description!!}</div>
                  </a>
               </div>
            </div>
            <div class="w-full md:w-1/2">
               <div class="flex flex-wrap md:ml-3">
                  @foreach($blogs as $blog)
                  <article class="w-1/2 mb-2 md:mb-6">
                     <div class="overflow-hidden rounded-sm shadow h-full mr-1 md:mr-3">
                        <a href="{{route('frontend-single-blog',$blog->slug)}}" class="block bg-white text-black no-underline h-full text-sm">
                           <img src="{{ asset('backend-asset/images/blog') }}/{{ $blog->featured_image }}" alt="{{ $blog->title }}"> 
                           <div class="p-4 pt-2">
                              <h3 class="text-base font-semibold md:text-xl">{{$blog->title}}</h3>
                             
                           </div>
                        </a>
                     </div>
                  </article>
                  @endforeach
               </div>
            </div>
         </div>
      </div>
   </div>
   
   <div class="flex justify-center bg-blue-lightest w-full">
      <div class="container flex flex-col justify-between py-16 px-2 md:flex-row md:py-20 md:px-0">
         <div class="flex justify-center items-center mb-4 md:justify-start md:pr-8">
            <i class="fa fa-envelope text-lg pr-2 md:text-5xl"></i> 
            <div>
               <h3>Start buying better.</h3>
               <p class="hidden md:block">Get instant access to our latest reviews, helpful tips and exclusive deals.</p>
            </div>
         </div>
         <div class="flex-grow">
            <form action="https://reviewsplus.co/newsletter" method="POST" class="flex"><input type="hidden" name="_token" value="Uq4pTxqVxb6OyTkAPl9JKyPOT2eHLAIglfyttr26"> <input name="email" type="text" placeholder="You'll be glad you did..." class="flex-grow rounded-l-sm p-4"> <input type="submit" value="Sign Me Up" class="bg-blue text-white rounded-r-sm p-2 md:p-4"></form>
         </div>
      </div>
   </div>
   <div class="container px-2 py-4 md:py-8 md:px-0">
      <div class="flex flex-col items-center">
         <h3 class="text-center uppercase w-full mb-4">Popular Deals</h3>
         <div class="flex flex-wrap w-full -mx-1 md:-mx-3">
            @foreach($coupons as $row)
            <article class="w-1/2 mb-4 md:w-1/4 md:mb-0 py-4">
               <div class="overflow-hidden rounded-sm shadow h-full mx-1 md:mx-3">
                  <div class="flex flex-col items-center bg-white text-black no-underline h-full">
                     <div class="flex justify-center items-center flex-grow"><img src="{{ asset('backend-asset/images/coupon') }}/{{ $row->featured_image }}" class="w-full"></div>
                     <div class="p-4 pt-2">
                        <p class="hidden font-light md:block">{{$row->title}}</p>
                        <h4 class="text-base font-semibold"> {{$row->description}}</h4>
                     </div>
                      @if($row->code == null)
                     <a href="{{ $row->url }}" target="_blank"  id="coupon-button" data-title="{{ $row->title }}" data-des="{{ $row->description }}" data-code="{{ $row->code }}" data-url="{{ $row->url }}" data-coupon_id="{{ $row->id }}"
                                    data-img="{{ asset('backend-asset/images/coupon') }}/{{ $row->featured_image }}" class="bg-blue rounded-sm text-white no-underline py-2 px-6 mb-4 uppercase hover:bg-blue-dark">Get This Deal</a>
                     @else
                     <a href="{{ $row->url }}" target="_blank"  id="coupon-button" data-title="{{ $row->title }}" data-des="{{ $row->description }}" data-code="{{ $row->code }}" data-url="{{ $row->url }}" data-coupon_id="{{ $row->id }}"
                                    data-img="{{ asset('backend-asset/images/coupon') }}/{{ $row->featured_image }}" class="bg-blue rounded-sm text-white no-underline py-2 px-6 mb-4 uppercase hover:bg-blue-dark">Get This Deal</a>
                     @endif
                  </div>
               </div>
            </article>
            @endforeach
         </div>
      </div>
   </div>
   <!--<div class="container">-->
   <!--   <div id="popular-cat-lg">-->
   <!--      <h3 class="text-center uppercase w-full mb-4">Popular Stores</h3>-->
   <!--      <div class="flex">-->
   <!--         <div class="mb-12 bg-white w-full" style="padding: 15px;">-->
   <!--               @foreach($stores as $index => $row)-->
   <!--                  @if($index % 4 == 0)-->
                        <!-- Close the previous row (if not the first) -->
   <!--                     @if($index != 0)-->
   <!--                           </div>-->
   <!--                     @endif-->
                        <!-- Open a new row -->
   <!--                     <div class="flex">-->
   <!--                  @endif-->

                     <!-- Each store -->
   <!--                  <p class="w-1/4 text-left text-grey-darker category-name">-->
   <!--                     <a href="{{ route('store-profile',$row->slug) }}" class="text-grey-darker" style="text-decoration: none;">-->
   <!--                           {{$row->name}}-->
   <!--                     </a>-->
   <!--                  </p>-->

                     <!-- Close the last row -->
   <!--                  @if($loop->last)-->
   <!--                     </div>-->
   <!--                  @endif-->
   <!--               @endforeach-->

   <!--            <div style="background-color: rgb(43, 113, 208); width: 10%; margin: 50px auto 0px; height: 2px;"></div>-->
   <!--         </div>-->
   <!--      </div>-->
   <!--   </div>-->
      <!--<div id="popular-cat-sm" style="max-width: 600px; margin: 0px auto;">-->
      <!--   <h4 class="text-left uppercase w-full pl-4">Popular Categories</h4>-->
      <!--   <div class="flex">-->
      <!--      <div class="mb-4 bg-white w-full" style="padding: 15px;">-->
      <!--         @foreach($stores as $index => $row)-->
      <!--               @if($index % 4 == 0)-->
                        <!-- Close the previous row (if not the first) -->
      <!--                  @if($index != 0)-->
      <!--                        </div>-->
      <!--                  @endif-->
                        <!-- Open a new row -->
      <!--                  <div class="flex">-->
      <!--               @endif-->

                 
      <!--            <p class="w-1/2  text-left text-grey-darker" style="padding: 4px; font-size: 14px;"><a href="{{ route('store-profile',$row->slug) }}" class="text-grey-darker" style="text-decoration: none;">{{$row->name}}</a></p>-->
      <!--         @if($loop->last)-->
      <!--                  </div>-->
      <!--               @endif-->
      <!--            @endforeach-->
      <!--      </div>-->
      <!-- </div>-->
      </div>
   </div>
</div>

@endsection