@extends('frontend.layout.master')
@php
$settings = \App\Models\GeneralSetting::find(1);
@endphp
@section('meta-content')

<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="@if($settings){{$settings->meta_desc}}@endif">
<meta name="tags" content="@if($settings){{$settings->meta_tags}}@endif">
<meta name="keywords" content="@if($settings){{$settings->meta_keywords}}@endif">
@endsection
@section('page-style')

<style type="text/css">
   .shadow-box{
      border: 1px solid rgba(0, 0, 0, 0.1);
       padding: 30px;
       background: #ffffff;
       border-radius: 10px;
   }

   .astrodivider {
     margin:33px auto;
     width:400px; 
     max-width: 100%;
     position:relative;
   }

   .astrodividermask { 
       overflow:hidden; height:20px; 
   }

   .astrodividermask:after { 
         content:''; 
         display:block; margin:-25px auto 0;
         width:100%; height:25px;  
           border-radius:125px / 12px;
          box-shadow:0 0 8px #f94d11;
   }
   .astrodivider span {
       width:40px; height:40px; 
       position:absolute; 
       bottom:100%; margin-bottom:-20px;
       left:50%; margin-left:-25px;
       border-radius:100%;
      box-shadow:0 2px 4px #f94d11;
       background:#fff;
   }
   .astrodivider i {
       position:absolute;
       top:4px; bottom:4px;
       left:4px; right:4px;
       border-radius:100%;
       border:1px dashed #f94d11;
       text-align:center;
       line-height:29px;
       font-style:normal;
        color:#f94d11;
   }

   .about-us{
      height: 500px;
      background-image: url({{ asset('frontend-asset/assets/images/about.png') }}); 
      background-position: center;
      background-size: 100% 500px; 
      background-repeat: no-repeat;
   }
   .about-text{
      font-size: 17px;
      line-height: 25px;
   }
</style>

@endsection


@section('content')

<section class="feature-sec container pad-top-md">
    <div class="container">
         <div class="row">
             <div class="col-xs-12" style="margin-top:20px;">
                 <div id="btnContainer">
                  <button class="btn" onclick="listView()"><i class="fa fa-bars"></i> List</button> 
                  <button class="btn active" onclick="gridView()"><i class="fa fa-th-large"></i> Grid</button>
                </div>
             </div>
         </div>
    </div>
</section>
<section class="results m-t-30">
            <div class="container">
               <div class="row">
                  <!--/col -->
                  <div class="col-sm-12">
                     
                     <div class="row">
                     	@foreach($exclusivecoupons as $exclusivecoupons)
                        <div class="col-sm-4 coloumn">
                           <div class="widget">
                              <div class="coupon-block equal">
                                 <a  href="javascript:void(0);" title="">
                                 <img src="{{ asset('backend-asset/images/coupon') }}/{{ $exclusivecoupons->featured_image }}" width="100" height="100" alt=""  style="margin-top: 30px !important;">
                                 </a>
                                 <div class="coupon-value" content="40%">{{ $exclusivecoupons->title }}</div>
                                 <h4 class="coupon-title"><a href="javascript:void(0);">{{ str_limit($exclusivecoupons->description,$limit = 60, $end = '...') }}</a></h4>
                                 <div class="action-block">
                                    @if($exclusivecoupons->code == null)
                                      <a href="{{ $exclusivecoupons->url }}" target="_blank"><p class="btn-code" id="coupon-button" data-title="{{ $exclusivecoupons->title }}" data-des="{{ $exclusivecoupons->description }}" data-code="{{ $exclusivecoupons->code }}" data-url="{{ $exclusivecoupons->url }}" data-coupon_id="{{ $exclusivecoupons->id }}"> <span class="partial-code">{{ $exclusivecoupons->code }}</span> <span class="btn-hover">Get Deal</span> </p></a>
                                      @else
                                      <a href="{{ $exclusivecoupons->url }}" target="_blank"><p class="btn-code" id="coupon-button" data-title="{{ $exclusivecoupons->title }}" data-des="{{ $exclusivecoupons->description }}" data-code="{{ $exclusivecoupons->code }}" data-url="{{ $exclusivecoupons->url }}" data-coupon_id="{{ $exclusivecoupons->id }}"> <span class="partial-code">{{ $exclusivecoupons->code }}</span> <span class="btn-hover">Get Code</span> </p></a>
                                     @endif
                                 </div>
                              </div>
                              <!--//coupon block -->
                           </div>
                        </div>
                        @endforeach
                        
                     </div>
                     <div class="row">
                       <div class="col-md-3"></div>
                       <div class="col-md-6 text-center"></div>
                       <div class="col-md-3"></div>
                     </div>
                  </div>
               </div>
            </div>
         </section>
         
         
         <section class="about-us">

               <div class="container">
                  <div class="row">
                     <div class="col-sm-12" align="center">
                        <div class="newsletter-form" style="max-width: 900px;">
                           <h2 style="color:#f94d11; "><b>About Us</b></h2>
                           <div class="astrodivider"><div class="astrodividermask"></div><span><i>&#10038;</i></span></div>
                           <p class="about-text">Influx Coupons is one of the well-known coupon sites around. It is the best place to look for promo codes, discount codes, coupons, voucher codes, and promotional codes, etc. We keep our data up-to-date so you will always find the best and latest working coupons for various stores. We work hard to provide you the best online deals, offers, and coupons. Our team also brings you exclusive 24 hours coupons and hot deals.<br> 
                           It’s easy to navigate your way through Influx Coupons because of its user-friendly interface. Through Influx Coupons, you can save money with three easy steps. First of all, search for the store, then copy coupon code and then you can shop and save.</p>
                        </div>
                     </div>
                  </div>
               </div>
               
            </section>



@endsection

@section('page-script')
<script>
// Get the elements with class="column"
var elements = document.getElementsByClassName("coloumn");

// Declare a loop variable
var i;

// List View
function listView() {
  for (i = 0; i < elements.length; i++) {
    elements[i].style.width = "100%";
  }
}

// Grid View
function gridView() {
  for (i = 0; i < elements.length; i++) {
    elements[i].style.width = "33.33%";
  }
}

/* Optional: Add active class to the current button (highlight it) */
var container = document.getElementById("btnContainer");
var btns = container.getElementsByClassName("btn");
for (var i = 0; i < btns.length; i++) {
  btns[i].addEventListener("click", function() {
    var current = document.getElementsByClassName("active");
    current[0].className = current[0].className.replace(" active", "");
    this.className += " active";
  });
}
</script>
@endsection