@extends('frontend.layout.master')
@php
$settings = \App\Models\GeneralSetting::find(1);
@endphp
@section('meta-content')

<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="@if($settings){{$settings->meta_desc}}@endif">
<meta name="tags" content="@if($settings){{$settings->meta_tags}}@endif">
<meta name="keywords" content="@if($settings){{$settings->meta_keywords}}@endif">
@endsection
@section('page-style')

<style type="text/css">
   .shadow-box{
      border: 1px solid rgba(0, 0, 0, 0.1);
       padding: 30px;
       background: #ffffff;
       border-radius: 10px;
   }

   .astrodivider {
     margin:33px auto;
     width:400px; 
     max-width: 100%;
     position:relative;
   }

   .astrodividermask { 
       overflow:hidden; height:20px; 
   }

   .astrodividermask:after { 
         content:''; 
         display:block; margin:-25px auto 0;
         width:100%; height:25px;  
           border-radius:125px / 12px;
          box-shadow:0 0 8px #f94d11;
   }
   .astrodivider span {
       width:40px; height:40px; 
       position:absolute; 
       bottom:100%; margin-bottom:-20px;
       left:50%; margin-left:-25px;
       border-radius:100%;
      box-shadow:0 2px 4px #f94d11;
       background:#fff;
   }
   .astrodivider i {
       position:absolute;
       top:4px; bottom:4px;
       left:4px; right:4px;
       border-radius:100%;
       border:1px dashed #f94d11;
       text-align:center;
       line-height:29px;
       font-style:normal;
        color:#f94d11;
   }

   .about-us{
      height: 500px;
      background-image: url({{ asset('frontend-asset/assets/images/about.png') }}); 
      background-position: center;
      background-size: 100% 500px; 
      background-repeat: no-repeat;
   }
   .about-text{
      font-size: 17px;
      line-height: 25px;
   }
</style>

@endsection

@section('content')


<section class="results m-t-30">
            <div class="container">
                <div class="row">
                    <div class="col-sm-3">
                       

                        <div class="widget categories b-b-0">
                        <!-- /widget heading -->
                        <div class="widget-heading">
                           <h3 class="widget-title text-dark">
                              Popular categories
                           </h3>
                            <div class="widget-widgets"> <a href="{{ route('frontend-categories') }}">More Categories <span class="ti-angle-right"></span></a> </div>
                           <div class="clearfix"></div>
                        </div>
                        <div class="widget-body">
                           <!-- Sidebar navigation -->
                           <ul class="nav sidebar-nav">
                              @foreach($cate as $category)
                              <li>
                                 <a href="{{ route('single-category',$category->slug) }}"> <i class="ti-gift">
                                 </i> {{ $category->name }} <!-- <span class="sidebar-badge">
                                 3
                                 </span> --> </a>
                              </li>
                              @endforeach
                           </ul>
                           <!-- Sidebar divider -->
                        </div>
                     </div>
                        <!-- //trending -->
                        
                        <!-- // tags -->
                        <div class="widget">
                            <!-- /widget heading -->
                            <div class="widget-heading">
                                <h3 class="widget-title text-dark">
                                  Top Stores  
                                </h3>
                                <div class="widget-widgets"> <a href="{{ route('frontend-stores') }}">More Stores <span class="ti-angle-right"></span></a> </div>
                                <div class="clearfix"></div>
                            </div>

                            <div class="widget-body">
                                <div class="row">
                                	@foreach($stores as $store)
                                    <div class="col-lg-6 col-md-2 col-sm-4 col-xs-6 thumb">
                                        <div class="thumb-inside">
                                            <a class="thumbnail" href="{{ route('store-profile',$store->slug) }}"> <img class="img-responsive" src="{{ asset('backend-asset/images/store') }}/{{ $store->featured_image }}" alt=""> </a> <span class="favorite"><a href="#" data-toggle="tooltip" data-placement="left" title="" data-original-title="Save store"><i class="ti-heart"></i></a></span> </div>
                                        <div class="store_name text-center">
                                            <h5>{{ $store->name }}</h5> </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/col -->
                    <div class="col-sm-9">
                      <section class="about-us" style="background-image: none;">

               <div class="container">
                  <div class="row">
                     <div class="col-sm-12" align="center">
                        <div class="newsletter-form" style="max-width: 900px;">
                           <h2 style="color:#f94d11; "><b>{{$events_details->name}}</b></h2>
                           <div class="astrodivider"><div class="astrodividermask"></div><span><i>&#10038;</i></span></div>
                           <p class="about-text">{{$events_details->description}}</p>
                           <img class="img-responsive store-img" src="{{ asset('backend-asset/images/events') }}/{{ $events_details->image }}">

                        </div>
                     </div>
                  </div>
               </div>
               
        </section>
                        <!-- <div class="widget">
                            <div class="widget-heading widget-default b-b-0">
                                <h3 class="widget-title text-dark">
                              Default Heading
                           </h3>
                                <div class="widget-widgets">
                                    <div class="form-group sort">
                                        <select class="select form-control">
                                            <option value="">Popular</option>
                                            <option value="">Latest</option>
                                            <option value="">Ending soon</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </div> -->
                        <!-- end: Widget -->
                        @foreach($eventcoupons as $coup)
                        <div class="coupon-wrapper coupon-single featured">
                            <div class="row">
                                <!-- <div class="ribbon-wrapper hidden-xs">
                                    <div class="ribbon">Featured</div>
                                </div> -->
                                <div class="coupon-data col-sm-2 text-center">
                                    <div class="savings text-center">
                                        <div>
                                            <!-- <div class="large">45%</div>
                                            <div class="small">off</div> -->
                                            <img src="{{ asset('backend-asset/images/coupon') }}/{{ $coup->featured_image }}" width="100" height="100">
                                            <div class="type">{{ $coup->type }}</div>
                                        </div>
                                    </div>
                                    <!-- end:Savings -->
                                </div>
                                <!-- end:Coupon data -->
                                <div class="coupon-contain col-sm-7">
                                    <ul class="list-inline list-unstyled">
                                        <li class="sale label label-pink">{{ $coup->type }}</li>
                                        <li class="popular label label-success">98% success</li>
                                        <li><span class="verified  text-success"><i class="ti-face-smile"></i>Verified</span> </li>
                                        <li><span class="used-count">{{ $coup->total_use }} used</span> </li>
                                    </ul>
                                    <h4 class="coupon-title"><a href="{{ $coup->url }}">{{ $coup->title }}</a></h4>
                                    <p data-toggle="collapse" data-target="#more">{{ $coup->description }}</p>
                                    <ul class="coupon-details list-inline">
                                        <li class="list-inline-item">
                                            <div class="btn-group" role="group" aria-label="...">
                                                <button type="button" class="btn btn-default btn-xs" data-toggle="tooltip" data-placement="left" title="" data-original-title="It worked"><i class="ti-thumb-up"></i> </button>
                                                <button type="button" class="btn btn-default btn-xs" data-toggle="tooltip" data-placement="top" title="" data-original-title="It didn't work"><i class="ti-thumb-down"></i> </button>
                                            </div>
                                            <!-- end:Btn group -->
                                        </li>
                                        <li class="list-inline-item">30% of 54 recommend</li>
                                        <li class="list-inline-item"><a href="#">Share</a> </li>
                                    </ul>
                                    <!-- end:Coupon details -->
                                </div>
                                <!-- end:Coupon cont -->
                                <div class="button-contain col-sm-3 text-center">
                                    @if($coup->code == null)
                                      <a href="{{ $coup->url }}" target="_blank"><p class="btn-code" id="coupon-button" data-title="{{ $coup->title }}" data-des="{{ $coup->description }}" data-code="{{ $coup->code }}" data-url="{{ $coup->url }}" data-coupon_id="{{ $coup->id }}"> <span class="partial-code">{{ $coup->code }}</span> <span class="btn-hover">Get Deal</span> </p></a>
                                      @else
                                      <a href="{{ $coup->url }}" target="_blank"><p class="btn-code" id="coupon-button" data-title="{{ $coup->title }}" data-des="{{ $coup->description }}" data-code="{{ $coup->code }}" data-url="{{ $coup->url }}" data-coupon_id="{{ $coup->id }}"> <span class="partial-code">{{ $coup->code }}</span> <span class="btn-hover">Get Code</span> </p></a>
                                     @endif
                                     <!-- <div class="btn-group" role="group" aria-label="...">
                                        <button type="button" class="btn btn-default btn-xs"><i class="ti-star"></i> </button>
                                        <button type="button" class="btn btn-default btn-xs"><i class="ti-email"></i> </button>
                                        <button type="button" class="btn btn-default btn-xs"><i class="ti-mobile"></i> </button>
                                    </div> -->
                                </div>
                            </div>
                            <!-- //row -->
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </section>
        
        <section class="about-us">

               <div class="container">
                  <div class="row">
                     <div class="col-sm-12" align="center">
                        <div class="newsletter-form" style="max-width: 900px;">
                           <h2 style="color:#f94d11; "><b>About Us</b></h2>
                           <div class="astrodivider"><div class="astrodividermask"></div><span><i>&#10038;</i></span></div>
                           <p class="about-text">Influx Coupons is one of the well-known coupon sites around. It is the best place to look for promo codes, discount codes, coupons, voucher codes, and promotional codes, etc. We keep our data up-to-date so you will always find the best and latest working coupons for various stores. We work hard to provide you the best online deals, offers, and coupons. Our team also brings you exclusive 24 hours coupons and hot deals.<br> 
                           It’s easy to navigate your way through Influx Coupons because of its user-friendly interface. Through Influx Coupons, you can save money with three easy steps. First of all, search for the store, then copy coupon code and then you can shop and save.</p>
                        </div>
                     </div>
                  </div>
               </div>
               
        </section>


        <!-- Large modal -->
         <div class="coupon_modal modal fade couponModal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg" role="document">
               <div class="modal-content">
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"><i class="ti-close"></i></span> </button>
                  <div class="coupon_modal_content">
                     
                     <div class="row">
                        <div class="col-sm-10 col-sm-offset-1 text-center">
                           <h2 class="modal-title"></h2>
                           <p class="modal-des"></p>
                        </div>
                         
                     <div class="row">
                         <div class="col-sm-12">
                             <h5 class="text-center text-uppercase m-t-20 text-muted for-code">Click below to get your coupon code</h5>
                             <h5 class="text-center text-uppercase m-t-20 text-muted for-deal" style="display:none;">Deal Activated, No Couon Code Required!</h5>
                         </div>
                         
                        <div class="col-sm-4 col-sm-offset-4 col-xs-6 col-xs-offset-3"> 
                        <a href="javascript:void(0)" class="coupon_code alert alert-info modal-url for-code"><span class="coupon_icon"><i class="ti-cut hidden-xs"></i></span> <input type="text" class="modal-code" value="" style="background-color:transparent; border:none; text-align:center;" readonly></a> 
                        <a href="" class="coupon_code alert alert-info modal-url for-deal" style="display:none;" title="Go To Store"><span class="coupon_icon"><i class="ti-link hidden-xs"></i></span> <span class="modal-code"></span></a>
                        <p class="text-center text_copied"></p> 
                        </div>
                     </div>
                     </div>
                  </div>
                  <!-- end: Coupon modal content -->
               </div>
            </div>
         </div>
         <!-- end: Modall -->



@endsection

@section('page-script')

<script type="text/javascript">
   
    
   $(document).on('click','#coupon-button',function(){
       $('.couponModal').modal({show:true});
      var get_code = $(this).data('code');
      var get_url = $(this).data('url');
      var get_title = $(this).data('title');
      var get_des = $(this).data('des');
      var get_id = $(this).data('coupon_id');
      $(this).parents('a').attr('href',get_url);
      
        $.ajax({
            type: "GET",
            contentType: "application/json; charset=utf-8",
            url: "{{ route('update_coupon_used') }}",
            dataType: "json",
            data:{id:get_id},
            success: function (data) {
                console.log(data);
            },
            error: function (data){
                console.log(data);
            }
        });
      
      if(get_code == ""){
          $('.for-code').css('display','none');
          $('.for-deal').css('display','block');
          $('.modal-url').attr('href',get_url);
      }
      else{
          $('.for-code').css('display','block');
          $('.for-deal').css('display','none');
          $('.modal-url').attr('href','javascript:void(0)');
      }

      $('.modal-code').val(get_code);
      //$('.modal-url').attr('href',get_url);
      $('.modal-title').text(get_title);
      $('.modal-des').text(get_des);

   });
   
   $('.modal-code').click(function(){
       $(this).focus();
       $(this).select();
       document.execCommand("copy");
       $('.text_copied').text('Copied');
   })

</script>

@endsection