@extends('frontend.layout.master')
@php
$settings = \App\Models\GeneralSetting::find(1);
@endphp
@section('meta-content')

<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="@if($settings){{$settings->meta_desc}}@endif">
<meta name="tags" content="@if($settings){{$settings->meta_tags}}@endif">
<meta name="keywords" content="@if($settings){{$settings->meta_keywords}}@endif">
@endsection
@section('content')
<div class="flex flex-wrap justify-center leading-normal w-full">
  <div class="container flex flex-col items-center px-2 py-6 md:px-0 md:py-8">
      <h2 class="text-lg uppercase">Our Top Picks</h2>
      <p class="font-light text-center mb-8">Thuroughly tested and evaluated by our expert editors to help you make a more informed buying decision.</p>
      <div class="flex flex-wrap justify-center mb-8">
         @foreach($categories as $category)
         <a href="{{ route('single-category',$category->slug) }}" class="flex flex-col flex-1 items-center no-underline px-16 py-4">
            <img class="h-16 w-16 flex items-center justify-center" src="{{ asset('backend-asset/images/category') }}/{{ $category->feature_image }}" alt="{{ $category->name }}">
             
            <p class="text-center text-sm text-black pt-1">{{ $category->name }}</p>
         </a>
         @endforeach
      </div>
   </div>
</div>

@endsection