@extends('frontend.layout.master')
@php
$settings = \App\Models\GeneralSetting::find(1);
@endphp
@section('meta-content')

<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="@if($settings){{$settings->meta_desc}}@endif">
<meta name="tags" content="@if($settings){{$settings->meta_tags}}@endif">
<meta name="keywords" content="@if($settings){{$settings->meta_keywords}}@endif">
@endsection
@section('content')
<div class="flex flex-wrap justify-center leading-normal w-full">
      <div class="container px-2 py-4 md:px-0">
         <h3 class="text-center text-black uppercase mb-4">All Blogs</h3>
         <div class="flex flex-col md:flex-row">
            <div class="w-full">
               <div class="flex flex-wrap md:ml-3">
                  @foreach($blogs as $blog)
                  <article class="w-1/4 mb-2 md:mb-6">
                     <div class="overflow-hidden rounded-sm shadow h-full mr-1 md:mr-3">
                        <a href="{{route('frontend-single-blog',$blog->slug)}}" class="block bg-white text-black no-underline h-full text-sm">
                           <img src="{{ asset('backend-asset/images/blog') }}/{{ $blog->featured_image }}" alt="{{ $blog->title }}"> 
                           <div class="p-4 pt-2">
                              <h3 class="text-base font-semibold md:text-xl">{{$blog->title}}</h3>
                             
                           </div>
                        </a>
                     </div>
                  </article>
                  @endforeach
                   
               </div>
               {{$blogs->links()}}
            </div>
           
         </div>
      </div>
   </div>


@endsection