@extends('backend.layout.master') @section('backend-content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Coupons</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('add-coupon') }}"><button class="btn btn-primary">Add New</button></a></li>
                    </ol>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->
    </section>
    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <!-- /.card-header -->
                    <div class="card-body">
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Status</th>
                                    <th>Featured Image</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($events as $rows)
                            	<tr>
                                    <td>{{ $rows->name }}</td>
                                    <td>{{ $rows->description }}</td>
                                    @if($rows->status == 1)
                                    <td>Active</td>
                                    @else
                                    <td>In Active</td>
                                    @endif
                                    <td><img src="{{ asset('backend-asset/images/events') }}/{{ $rows->image }}" width="50" height="50"></td>
                                    <td>
                                        <a href="{{ route('edit-event',$rows->id) }}"><button class="btn btn-success">Edit</button></a> 
                                    </td>
                                </tr>
                                @endforeach
                                
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Status</th>
                                    <th>Featured Image</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>

</div>
@endsection @section('page-script')

<script>
    
   $(document).ready(function () {
  bsCustomFileInput.init();
});
</script>

@endsection