@extends('backend.layout.master') @section('backend-content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Edit New Coupon</h1>
                </div>
                <!-- <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">DataTables</li>
                    </ol>
                </div> -->
            </div>
        </div>
        <!-- /.container-fluid -->
    </section>
    <section class="content">
        <div class="row">
        	<div class="col-12">
			    <form method="post" action="{{ route('edit-coupon-post') }}" enctype="multipart/form-data">
                @csrf
			        <div class="card">
			            <input type="hidden" name="coupon_id" value="{{ $coup->id }}">
			            <div class="card-body">
			                <div class="col-md-12">
                                    <div class="form-group">
                                        <input type="hidden" value="{{ $coup->store_id }}" id="storeid" name="">
                                        <label for="exampleInputFile">Store</label>
                                        <select class="form-control" name="store" id="store">
                                            @foreach($store as $rows)
                                            <option value="{{ $rows->id }}">{{ $rows->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
			                <div class="form-group">
			                    <label for="exampleInputEmail1">Title</label>
			                    <input type="text" class="form-control" id="exampleInputEmail1" placeholder="Store Name" name="title" value="{{ $coup->title }}">
			                </div>
                            <div class="form-group">
                                <label for="exampleInputEmail1">Coupon Description</label>
                                <textarea class="form-control" name="description" placeholder="Store Description">{{ $coup->description }}</textarea>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputFile">Coupon Code</label>
                                        <input type="text" class="form-control" name="code" value="{{ $coup->code }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputFile">Total Usage</label>
                                        <input type="text" class="form-control" name="totaluse" value="{{ $coup->total_use }}">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                 <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="exampleInputFile">URL</label>
                                        <input type="text" class="form-control" name="url" value="{{ $coup->url }}">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="hidden" value="{{ $coup->type }}" id="typeid" name="">
                                        <label for="exampleInputFile">Type</label>
                                        <select class="form-control" name="type" id="type">
                                            <option value="Sale">Sale</option>
                                            <option value="Deal">Deal</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="hidden" value="{{ $coup->status }}" id="statusid" name="">
                                        <label for="exampleInputFile">Status</label>
                                        <select class="form-control" name="status" id="status">
                                            <option value="Active">Active</option>
                                            <option value="In Active">In Active</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="exampleInputFile">Category</label>
                                        <input type="hidden" value="{{ $coup->category_id }}" id="categyid" name="">
                                        <select class="form-control" id="category" name="category" id="category">
                                            <option>Select Category</option>
                                            @foreach($cate as $row)
                                            <option value="{{ $row->id }}">{{ $row->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                
                            </div>
                            
                            <div class="row">
                                 <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="exampleInputFile">Expire Within</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                              <span class="input-group-text">
                                                <i class="far fa-calendar-alt"></i>
                                              </span>
                                            </div>
                                            <input type="text" name="expire" class="form-control float-right" id="reservation" value="{{ $coup->start_date }} - {{ $coup->end_date}}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="exampleInputFile">Feature Image</label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" name="file" class="custom-file-input" id="exampleInputFile">
                                                <label class="custom-file-label" for="exampleInputFile">Choose file</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
			                <div class="row">
                                 <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="exampleInputFile">Sorting Order</label>
                                        <div class="input-group">
                                            <input type="text" name="sorting_order" class="form-control float-right" id="sorting_order" value="{{ $coup->sorting_order }}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
			            </div>
			            <div class="card-footer">
			                <button type="submit" class="btn btn-primary btn_submit">Save</button>
			            </div>
			        </div>
			    </form>
			</div>
        </div>
        <!-- /.row -->
    </section>

</div>
@endsection @section('page-script')

<script>
   
   $(document).ready(function () {
      bsCustomFileInput.init();
    });

   $(document).on('change','#category',function(){

        var cateid = this.value;

        $.ajax({
            type: "GET",
            url: "{{ route('sub-category-api') }}",
            data: {
                categoryid: cateid
            },
            success: function(result) {
                var opt = '';
                for (var i = 0; i < result.subcategory.length; i++) {
                    opt += '<option value="'+result.subcategory[i].id+'">'+result.subcategory[i].name+'</option>';
                }
                $('#subcate').html(opt);
            },
            error: function(error) {
                toastr.error(error.message);
            }
        }); 
   });
   //Date range picker
    $('#reservation').daterangepicker();
    var timer, delay = 500;
        $('input[name="sorting_order"]').bind('keydown blur change', function(e) {
            var _this = $(this);
            clearTimeout(timer);
            timer = setTimeout(function() {
                $.ajax({
                    type: "GET",
                    url: "{{ route('check_sorting_order') }}",
                    data: {
                        store_id:$('select[name="store"] option:selected').val(),
                        sorting_order:_this.val(),
                    },
                    dataType:'json',
                    success: function(result) {
                        if(_this.val() != ""){
                            if(result.success == true){
                                toastr.success(result.message);
                                $('.btn_submit').attr('disabled',false);
                            }else if(result.success == false){
                                $('.btn_submit').attr('disabled',true);
                                toastr.error(result.message);
                            }
                        }
                    },
                    error: function(error) {
                        toastr.error(error.message);
                    }
                }); 
            }, delay );
        });


    $(document).ready(function(){
        var type = $('#typeid').val();
        var status = $('#statusid').val();
        var cate = $('#categyid').val();
        var store = $('#storeid').val();
        var event = $('#eventid').val();


        $('#type').find('option[value="'+type+'"]').attr("selected",true);
        $('#status').find('option[value="'+status+'"]').attr("selected",true);
        $('#category').find('option[value="'+cate+'"]').attr("selected",true);
        $('#store').find('option[value="'+store+'"]').attr("selected",true);
        $('#event').find('option[value="'+event+'"]').attr("selected",true);

    });
</script>

@endsection