@extends('backend.layout.master') @section('backend-content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Categories</h1>
                </div>
                <!-- <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">DataTables</li>
                    </ol>
                </div> -->
            </div>
        </div>
        <!-- /.container-fluid -->
    </section>
    <section class="content">
        <div class="row">
        	<div class="col-6">
			    <form method="post" action="{{ route('add-category') }}" enctype="multipart/form-data">
                @csrf
			        <div class="card">
			            <div class="card-header bg-primary">
			                <h4>Add New Category</h4>
			            </div>
			            <div class="card-body">
			                <div class="form-group">
			                    <label for="exampleInputEmail1">Title</label>
			                    <input type="text" class="form-control" id="exampleInputEmail1" placeholder="Category Name" name="category_name">
			                </div>
                            <div class="form-group">
                                <label for="exampleInputEmail1">Meta Title</label>
                                <input type="text" class="form-control" id="exampleInputEmail1" placeholder="Meta Title" name="metatitle">
                            </div>
                            <div class="form-group">
                                <label for="exampleInputEmail1">Meta Description</label>
                                <textarea class="form-control" name="metadescription" placeholder="Meta Description"></textarea>
                            </div>
			                <div class="form-group">
			                    <label for="exampleInputFile">Feature Image</label>
			                    <div class="input-group">
			                        <div class="custom-file">
			                            <input type="file" name="file" class="custom-file-input" id="exampleInputFile">
			                            <label class="custom-file-label" for="exampleInputFile">Choose file</label>
			                        </div>
			                    </div>
			                </div>

			            </div>
			            <div class="card-footer">
			                <button type="submit" class="btn btn-primary">Save</button>
			            </div>
			        </div>
			    </form>
			</div>
            <div class="col-6">
                <div class="card">
                    <!-- /.card-header -->
                    <div class="card-body">
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>Category</th>
                                    <th>Feature Image</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            	@foreach($cate as $row)
                                <tr>
                                    <td>{{ $row->name }}</td>
                                    <td><img src="{{ asset('backend-asset/images/category') }}/{{ $row->feature_image }}" width="30" height="30"></td>
                                    <td>
                                        <a href="{{ route('edit-category',$row->id) }}"><button class="btn btn-success">Edit</button></a> |
                                        <a href="{{ route('delete-category',$row->id) }}"><button class="btn btn-danger">Delete</button></a>
                                    </td>
                                </tr>
                                @endforeach
                                
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Category</th>
                                    <th>Feature Image</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>

</div>
@endsection @section('page-script')

<script>
    
   $(document).ready(function () {
  bsCustomFileInput.init();
});
</script>

@endsection