@extends('backend.layout.master') @section('backend-content')
<style>
    .comments-details button.btn.dropdown-toggle,
.comments-details .total-comments {
    font-size: 18px;
    font-weight: 500;
    color: #5e5e5e;
}
.comments-details {
    padding: 15px 15px;
}
.comments .comments .dropdown,
.comments .dropup {
    position: relative;
}
.comments button {
    /*background-color: transparent;*/
    border: none;
}
.comments .comment-box {
    width: 100%;
    float: left;
    height: 100%;
    background-color: #FAFAFA;
    padding: 10px 10px 10px;
    /*margin-bottom: 15px;*/
    /*margin-top: -95px;*/
    margin-bottom: 23px;
    border-radius: 5px;
    border: 1px solid #ddd;
}
.comments .add-comment {
    background-color: transparent;
    border: none;
    position: relative;
    margin-bottom: 78px;
}
.comments .commenter-pic {
    width: 50px;
    height: 50px;
    display: inline-block;
    border-radius: 100%;
    border: 2px solid #fff;
    overflow: hidden;
    background-color: #fff;
}
.comments .add-comment .commenter-name {
    width: 100%;
    padding-left: 75px;
    /*position: absolute;*/
    top: -56px;
    left: 0px;
}
.comments .add-comment input {
    border-top: 0px;
    border-bottom: 1px solid #ccc;
    border-left: 0px;
    border-right: 0px;
    outline: 0px;
    box-shadow: none;
    border-radius: 0;
    width: 100%;
    padding: 10px;
    font-weight: normal;
}
.comments .add-comment input:focus {
    border-color: #03a9f4;
    border-width: 2px;
}
.comments .add-comment button[type=submit] {
    background-color: #03a9f4;
    color: #fff;
    margin-right: 0px;
}
.comments .add-comment button {
    background-color: #f5f5f5;
    margin: 10px 5px;
    font-size: 14px;
    text-transform: uppercase;
    float: right;
}
.comments .commenter-name .comment-time {
    font-weight: normal;
    margin-left: 8px;
    font-size: 15px;
}
.comments p.comment-txt {
    font-size: 15px;
    border-bottom: 1px solid #ddd;
    padding: 0px 0px 15px;
}
.comments .commenter-name {
    display: inline-block;
    position: relative;
    top: -20px;
    left: 10px;
    font-size: 16px;
    font-weight: bold;
}
.comments .comment-meta {
    font-size: 14px;
    color: #333;
    padding: 2px 5px 0px;
    line-height: 20px;
    float: right;
}
.comments .reply-box {
    display: none;
}
.comments .replied {
    background-color: #fff;
    width: 95%;
    float: right;
    margin-top: 15px;
}

/*======Responsive CSS=======*/
@media (max-width: 767px){
.comments .commenter-name {
    font-size: 13px;
    top: -5px;
}
.comments .commenter-pic {
    width: 40px;
    height: 40px;
}
.comments .commenter-name a{
  display: block;
}
.comments .commenter-name .comment-time{
  display: block;
  margin-left: 0px;
}
}
</style>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Blog Comments</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                    </ol>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->
    </section>
    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <!-- /.card-header -->
                    <div class="card-body">
                       <div class="row">
                           <div class="col-md-12">
                               <div class="comments">
                                @foreach($comments as $row)
                                <div class="comment-box">
                                  <span class="commenter-pic">
                                    <img src="{{ asset('public/avatar.png') }}" class="img-fluid" style="height: 50px;width: 78px;margin-left: -16px;">
                                  </span>
                                  <span class="commenter-name">
                                    <a href="#">{{ $row->name }}</a> <span class="comment-time">{{ \Carbon\Carbon::parse($row->created_at)->diffForhumans() }}</span>
                                  </span>       
                                  <p class="comment-txt more">{!! $row->comment !!}</p>
                                  <div class="comment-meta">
                                     @if($row->status == 0)
                                    <a href="{{ route('approve',$row->id) }}" class="comment-reply reply-popup btn btn-primary"> Approve</a>  
                                    @else
                                    <button class="comment-reply reply-popup btn btn-success"> Approved</button>  
                                    @endif
                                  </div>
                                  <div class="comment-meta">        
                                  </div>
                                </div>
                                @endforeach
                              </div>
                           </div>
                       </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>

</div>