<?php

namespace App\Http\Controllers\Frontend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Coupon;
use App\Models\Store;
use App\Models\Category;
use App\Models\Banner;
use App\Models\Blog;
use App\Models\Event;
use App\Models\Page;
use App\Support\Collection;
use DB;

class HomeController extends Controller
{
    public function sitemap(){
         $page_data = array(
            'title' => 'sitemap'
        );
        return view('frontend.pages.sitemap',compact('page_data'));
    }
    public function index(){
       $page_data = array(
            'title' => 'Home'
        );
    	$latestcoupons = Coupon::limit(12)->inRandomOrder()->get();
    	$coupons = Coupon::limit(20)->inRandomOrder()->get();
        $categories = Category::limit(7)->get();
        $blogs = Blog::limit(5)->inRandomOrder()->get();
        $stores = Store::select('stores.id','stores.name','stores.slug','stores.featured_image')->limit(12)->inRandomOrder()->get();
    	$banner = Banner::get();
    	$content = DB::table('sitecontent')->orderby('id','desc')->first();
    	return view('frontend.pages.index',get_defined_vars());
    }
    
    public function global_search(Request $request){
        if(!empty($request->input('item'))){
            $coupons = Coupon::where('title','like','%'.$request->input('item').'%')->get();  
            $stores = Store::where('name','like','%'.$request->input('item').'%')->get();
            if(count($coupons) > 0){
                foreach($coupons as $row){
                    $coup[] = array(
                        'name' => $row['title'],
                        'type' => 'coupon',
                    );
                }   
            }else{
                $coup = [];
            }
            
            if(count($stores) > 0){
                foreach($stores as $row){
                    $stor[] = array(
                        'name' => $row['name'],
                        'type' => 'store'
                    );
                }  
            }else{
                $stor = [];
            }
            
            $data = array_merge($coup,$stor);
            
            return response()->json($data);
            
        }
    }
   
    public function getstores(Request $request){
        if(!empty($request->key)){
             
            $stores = Store::where('name','like','%'.$request->key.'%')->select('stores.id','stores.name','stores.slug','stores.featured_image')->get();
            
            
            return view('frontend.pages.autocomplete',compact('stores'));
            
        }
    }
    public function coupons(){
         $page_data = array(
            'title' => 'Coupons'
        );
    	$coupons = Coupon::orderby('updated_at','desc')->paginate(30);
    	$stores = Store::select('stores.id','stores.name','stores.slug','stores.featured_image')->limit(6)->inRandomOrder()->get();
    	$blogs = Blog::select('blogs.id','blogs.title','blogs.slug','blogs.featured_image')->limit(5)->inRandomOrder()->get();
    	$cate = Category::limit(10)->inRandomOrder()->get();
    	return view('frontend.pages.coupon',get_defined_vars());
    }
    
    public function search_coupons(Request $request){
        if(!empty($request->input('q'))){
            $coupons = Coupon::where('title','like','%'.$request->input('q').'%')->get();   
        }else{
           $coupons = Coupon::all(); 
        }
    	$stores = Store::limit(6)->inRandomOrder()->get();
    	$cate = Category::limit(5)->inRandomOrder()->get();
    	return view('frontend.pages.coupon',compact('coupons','stores','cate'));
    }

    public function stores(){
         $page_data = array(
            'title' => 'Stores'
        );
    	$stores = Store::select('stores.id','stores.name','stores.slug','stores.featured_image','stores.description')->inRandomOrder()->paginate(60);	
    	
    	return view('frontend.pages.store',get_defined_vars());
    }
    
    public function search_stores(Request $request){
        if(!empty($request->input('q'))){
            $stores = Store::where('name','like','%'.$request->input('q').'%')->paginate(50);
        }else{
            $stores = Store::paginate(50);	
        }
        return view('frontend.pages.store',get_defined_vars());
    }
    
    public function categories(){
         $page_data = array(
            'title' => 'Categories'
        );
    	$categories = Category::select('categories.id','categories.name','categories.slug','categories.feature_image')->inRandomOrder()->get();	
    	return view('frontend.pages.categories',get_defined_vars());
    }

    public function storeProfile($slug){
         $page_data = array(
            'title' => 'stores / '.$slug
        );

        $store = Store::where('slug',$slug)->first();
    
        $end_date = DB::raw("DATE_FORMAT(STR_TO_DATE(`end_date`, '%m-%d-%Y'),'%Y-%m-%d')");

        $coupons = Coupon::where('store_id',$store->id)->where($end_date,'>=',date('Y-m-d'))->orderby('sorting_order','asc')->paginate(20);
        
        $expired_coupons = Coupon::where('store_id',$store->id)->where($end_date,'<',date('Y-m-d'))->orderby('sorting_order','asc')->get();
        // dd($expired_coupons);
        $top_stores = Store::select('stores.id','stores.name','stores.slug','stores.featured_image')->limit(6)->inRandomOrder()->get();
        $cate = Category::select('categories.id','categories.name','categories.slug','categories.feature_image')->limit(10)->inRandomOrder()->get();
        return view('frontend.pages.storeprofile',get_defined_vars());

    }

    public function singleCategory($slug){
         $page_data = array(
            'title' =>'categories / '.$slug
        );

        $cate = Category::where('slug',$slug)->first();

        $coupons = Coupon::where('category_id',$cate->id)->orderby(DB::raw("str_to_date(end_date,'%Y-%m-%d')"), 'DESC')->paginate(20);
        $top_stores = Store::select('stores.id','stores.name','stores.slug','stores.featured_image')->limit(6)->inRandomOrder()->get();
        $category = Category::select('categories.id','categories.name','categories.slug','categories.feature_image')->limit(10)->inRandomOrder()->get();
        return view('frontend.pages.singlecategory',get_defined_vars());

    }

    public function blogs(){
         $page_data = array(
            'title' => 'Blog'
        );
        $blogs = Blog::select('blogs.id','blogs.title','blogs.slug','blogs.featured_image')->Orderby('id','desc')->paginate(20);
        $cate = Category::select('categories.id','categories.name','categories.slug','categories.feature_image')->limit(10)->inRandomOrder()->get();
        $stores = Store::select('stores.id','stores.name','stores.slug','stores.featured_image')->limit(6)->inRandomOrder()->get();
        return view('frontend.pages.blogs',get_defined_vars());
    }

    public function singleBlog($slug){
         $page_data = array(
            'title' => 'Blogs / '.$slug
        );
        $blog = Blog::where('slug',$slug)->first();
        $blogs = Blog::select('blogs.id','blogs.title','blogs.slug','blogs.featured_image')->limit(10)->inRandomOrder()->get();
        $cate = Category::select('categories.id','categories.name','categories.slug','categories.feature_image')->limit(10)->limit(10)->inRandomOrder()->get();
        $stores = Store::select('stores.id','stores.name','stores.slug','stores.featured_image')->limit(6)->inRandomOrder()->get();
        return view('frontend.pages.singleblog',get_defined_vars());
    }

    public function emailSubscription(Request $request){
        
        $email = DB::table('subscription')->insert(['email' => $request->email]);

        if( $email ){
            return redirect()->route('frontend-index');
        }
        else{
            return redirect()->route('frontend-index');   
        }
    }
    
    public function privacyPolicyView(){
         $page_data = array(
            'title' => 'Privacy Policy'
        );
        return view('frontend.pages.privacypolicy',compact('page_data'));
    }
    
    public function OurCompany(){
         $page_data = array(
            'title' => 'Our Company'
        );
        return view('frontend.pages.our-company',compact('page_data'));
    }

    public function termConditionView(){
         $page_data = array(
            'title' => 'Terms and Condition'
        );
        return view('frontend.pages.termsandcondition',compact('page_data'));
    }
    
    public function update_coupon_used(Request $request){
        $used = Coupon::where('id',$request->id)->first();
        if(!empty($used)){
            $coupon = Coupon::where('id',$request->id)->update(array('total_use' => intval($used->total_use) + 1));
            
            return response()->json(['data' => $coupon, 'success' => true]);
        }
    }
    
    public function post_comment(Request $request){
        $data = array(
            'name' => $request->name,
            'comment' => $request->comment,
            'blog_id' => $request->blog_id,
            'status' => 0
        );
        
        $insert = DB::table('blog_comments')->insert($data);
        
        toastr()->success('Comment added successfully');
        return back();
        
    }
    public function exclusivecoupons(){

        $exclusivecoupons = Coupon::where('exclusive',1)->paginate(50);  
        return view('frontend.pages.exclusive',compact('exclusivecoupons'));
    }

    public function eventcoupons($id){
        $eventsoup = Event::where('status',1)->where('id',$id)->first();
        if($eventsoup->status == 1)
        {
        $eventcoupons = Coupon::leftjoin('events','coupons.event_id','events.id')
        ->where('coupons.event_id',$id)
        ->where('events.status',1)
        ->select('coupons.*','events.name as event_name','events.description as event_description','events.image as events_image')
        ->paginate(50);
        $stores = Store::select('stores.id','stores.name','stores.slug','stores.featured_image')->limit(6)->inRandomOrder()->get();
        $cate = Category::select('categories.id','categories.name','categories.slug','categories.feature_image')->limit(10)->limit(5)->inRandomOrder()->get();
        $events_details = Event::where('id',$id)->first();
        return view('frontend.pages.events',compact('eventcoupons','stores','cate','events_details'));
        }
    }

    public function Page($slug)
    {
          $page = Page::where('slug',$slug)->first();
        return view('frontend.pages.page',compact('page'));
    }

       
    
}
