<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Subcategory;
use App\Models\Category;
use Illuminate\Support\Str;

class SubcategoryController extends Controller
{
    public function subCategoryView(){
        if(session()->get('id')!=null)
    {
    	$sub = Subcategory::join('categories', 'sub_categories.category_id', '=', 'categories.id')
    						->select('sub_categories.id', 'sub_categories.name', 'sub_categories.slug','sub_categories.feature_image','sub_categories.category_id','categories.name as category_name')
    						->get();
    	$cate = Category::select('categories.id','categories.name')->get();
    	return view('backend.pages.subcategory.subcategorylist',compact('sub','cate'));
    }else{
        return redirect()->route('login');
    }
    }

    public function subCategoryAdd(Request $request){

    	$cate = new Subcategory;

    	if($request->hasFile('file')){

    		$file = $request->file('file');
	    	$image = uniqid().'.'.$file->guessExtension();
	    	$image_path = $file->move(public_path().'/backend-asset/images/sub-category/',$image);

	    	$cate->name = $request->category_name;
	    	$cate->slug = Str::slug($request->category_name);
	    	$cate->feature_image = $image;
	    	$cate->category_id = $request->category_id;

	    	if( $cate->save() ){
	    		toastr()->success('Category Add Successfully');
	    		return redirect()->route('sub-category');
	    	}
	    	else{
	    		toastr()->error('Something went wrong');
	    		return redirect()->route('sub-category');
	    	}
	    }
	    else{
	    	toastr()->error('Image Error');
	    		return redirect()->route('sub-category');
	    }

    }

    public function editSubCategoryView($id){
        if(session()->get('id')!=null)
    {
    	$subcate = Subcategory::where('id',$id)->first();
    	$cate = Category::select('categories.id','categories.name')->get();
    	return view('backend.pages.subcategory.editsubcategory',compact('subcate','cate'));
    }else{
        return redirect()->route('login');
    }
    }

    public function editSubCategoryPost(Request $request){

    	$cate = Subcategory::find( $request->sub_category_id );

    	if($request->hasFile('file')){

    		$file = $request->file('file');
	    	$image = uniqid().'.'.$file->guessExtension();
	    	$image_path = $file->move(public_path().'/backend-asset/images/category/',$image);

	    	$cate->name = $request->category_name;
	    	$cate->slug = Str::slug($request->category_name);
	    	$cate->feature_image = $image;
	    	$cate->category_id = $request->category_id;

	    	if( $cate->save() ){
	    		toastr()->success('Category Update Successfully');
	    		return redirect()->route('sub-category');
	    	}
	    	else{
	    		toastr()->error('Something went wrong');
	    		return redirect()->route('sub-category');
	    	}
	    }
	    else{

	    	$cate->name = $request->category_name;
	    	$cate->slug = Str::slug($request->category_name);
	    	$cate->category_id = $request->category_id;

	    	if( $cate->save() ){
	    		toastr()->success('Category Update Successfully');
	    		return redirect()->route('sub-category');
	    	}
	    	else{
	    		toastr()->error('Something went wrong');
	    		return redirect()->route('sub-category');
	    	}
	    }

    }

    public function deleteSubCategory($id){
    	$cate = Subcategory::find( $id );

    	if( $cate->delete() ){
	    	toastr()->success("Delete Successfull");
	    	return redirect()->route('sub-category');
    	}
    	else{
    		toastr()->error("Something went wrong");
	    	return redirect()->route('sub-category');
    	}
    }
}
