<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Store;
use App\Models\Coupon;
use Illuminate\Support\Str;

class StoreController extends Controller
{
    public function storeView(){
     if(session()->get('id')!=null)
    {   
    	$stores = Store::select('stores.id','stores.name','stores.slug','stores.featured_image','stores.description')->orderby('id','desc')->get();
    	return view('backend.pages.stores.storelist',compact('stores'));
    }else{
        return redirect()->route('login');
    }
    }

    public function addStoreView(){
        if(session()->get('id')!=null)
    {
    	return view('backend.pages.stores.addstore');
    }else{
        return redirect()->route('login');
    }
    }

    public function addStore(Request $request){
    	$store = new Store;

    	if($request->hasFile('file')){
    		$file = $request->file('file');
    		$image = uniqid().'.'.$file->guessExtension();
    		$image_path = $file->move(public_path().'/backend-asset/images/store/',$image);

    		$store->name = $request->name;
    		$store->slug = Str::slug($request->name);
    		$store->description = $request->description;
    		$store->blog_description = $request->blogdescription;
            $store->meta_title = $request->metatitle;
            $store->meta_description = $request->metadescription;
    		$store->featured_image = $image;

    		if( $store->save() ){
    			toastr()->success('Store Add Successfully');
    			return redirect()->route('stores');
    		}
    		else{
    			toastr()->error('Something went wrong');
    			return redirect()->back();
    		}
    	}
    	else{
    		toastr()->error('Something went wrong in image');
    		return redirect()->back();
    	}
    }

    public function editStoreView($id){
        if(session()->get('id')!=null)
    { 
        $store = Store::where('id',$id)->first();
        return view('backend.pages.stores.editstore',compact('store'));
    }else{
        return redirect()->route('login');
    }
    }

    public function editStorePost(Request $request){

        $store = Store::find( $request->store_id );

        if($request->hasFile('file')){

            $file = $request->file('file');
            $image = uniqid().'.'.$file->guessExtension();
            $image_path = $file->move(public_path().'/backend-asset/images/store/',$image);

            $store->name = $request->name;
            $store->slug = Str::slug($request->name);
            $store->description = $request->description;
            $store->blog_description = $request->blogdescription;
            $store->meta_title = $request->metatitle;
            $store->meta_description = $request->metadescription;
            $store->featured_image = $image;

            if( $store->save() ){
                toastr()->success('Store Update Successfully');
                return redirect()->route('stores');
            }
            else{
                toastr()->error('Something went wrong');
                return redirect()->route('stores');
            }
        }
        else{

            $store->name = $request->name;
            $store->slug = Str::slug($request->name);
            $store->description = $request->description;
            $store->blog_description = $request->blogdescription;
            $store->meta_title = $request->metatitle;
            $store->meta_description = $request->metadescription;

            if( $store->save() ){
                toastr()->success('Store Update Successfully');
                return redirect()->route('stores');
            }
            else{
                toastr()->error('Something went wrong');
                return redirect()->route('stores');
            }
        }

    }

    public function deleteStore($id){
        $store = Store::find( $id );

        if( $store->delete() ){
            toastr()->success("Delete Successfull");
            return redirect()->route('stores');
        }
        else{
            toastr()->error("Something went wrong");
            return redirect()->route('stores');
        }
    }
    
    public function coupons($id){
        $query = Coupon::where('store_id',$id)->orderby('sorting_order','asc')->get();
        return view('backend.pages.stores.coupon',compact('query'));
    }
    
    public function update_order(Request $request){
        $query = Coupon::where('store_id',$request->store_id)->orderby('sorting_order','asc')->get();
        $count = 0;
        foreach($request->item as $row){
            // $arr[] = $request->item[$count];
            $coupon = Coupon::where('id',$row)->first();
            $coupon->sorting_order = $count;
            $coupon->save();
            $count++;
        }
        // foreach($request->item as $row){
        //     $arr[] = $row;
        // }
        if($coupon){
            return response()->json(['data' => $coupon, 'success' => true]);
        }else{
            return response()->json(['data' => null, 'success' => false]);
        }
    }
}
