<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Page;
use Str;

class PageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $pages= Page::all();
        return view('backend.pages.page',compact('pages'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('backend.pages.add-page');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $page = new Page();
        $page->title = $request->title;
        $page->slug = Str::slug($request->title);
        $page->details = $request->details;
        if($page->save())
        {
            toastr()->success('Page Added Successfully');
            return back();
        }
        else{
            toastr()->error('Something went wrong!');
            return back();
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $page = Page::find($id);
        return view('backend.pages.edit-page',compact('page'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //
        // dd($request->all());
        $page = Page::find($request->id);
        $page->title = $request->title;        
        $page->slug = Str::slug($request->title);
        $page->details = $request->details;
        if($page->save())
        {
            toastr()->success('Page Updated Successfully');
            return back();
        }
        else{
            toastr()->error('Something went wrong!');
            return back();
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $page = Page::find($id);
        if($page->delete())
        {
            toastr()->success('Page Deleted Successfully');
            return back();
        }
        else{
            toastr()->error('Something went wrong!');
            return back();
        }

    }
}
