<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Coupon;
use App\Models\Event;

class EventController extends Controller
{
    public function index()
    {
        if(session()->get('id')!=null)
    {
    	return view('backend.pages.event.event');
    }else{
        return redirect()->route('login');
    }
    }
    public function addevent(Request $request)
    {
    	$event = new Event;
    	$splitDate = explode(' - ', $request->expire);

    	
    	
    	if($request->hasFile('file')){
    		$file = $request->file('file');
    		$image = uniqid().'.'.$file->guessExtension();
    		$image_path = $file->move(public_path().'/backend-asset/images/events/',$image);

    		$event->name = $request->name;
    		$event->description = $request->description;
    		$event->image = $image;
    		$event->status = 1;


    		if( $event->save() ){
    			toastr()->success('Events Add Successfully');
    			return redirect()->route('event-view');
    		}
    		else{
    			toastr()->error('Something went wrong');
    			return redirect()->back();
    		}
    	}
    	else{
    		toastr()->error('Something went wrong in image');
    		return redirect()->back();
    	}
    }
    public function eventView(){
         if(session()->get('id')!=null)
    {
    	$events = Event::get();
    	
    	return view('backend.pages.event.eventlist',compact('events'));
    }else{
        return redirect()->route('login');
    }
    }
    public function editEventView($id){
        $event = Event::where('id',$id)->first();
        

        return view('backend.pages.event.editevent',compact('event'));
    }
     public function editEventPost(Request $request){
        
        $event = Event::find( $request->event_id );
        $splitDate = explode(' - ', $request->expire);

        $update = date('Y-m-d H:i:s');
        
        if($request->hasFile('file')){

            $file = $request->file('file');
            $image = uniqid().'.'.$file->guessExtension();
            $image_path = $file->move(public_path().'/backend-asset/images/events/',$image);

            $event->name = $request->name;
            $event->description = $request->description;
            $event->status = $request->status;
            $event->image = $image;
            $event->updated_at = $update;
            
            if( $event->save() ){
                toastr()->success('Coupon Update Successfully');
                return redirect()->route('event-list');
            }
            else{
                toastr()->error('Something went wrong');
                return redirect()->route('event-list');
            }
        }
        else{

            $event->name = $request->name;
            $event->description = $request->description;
            $event->status = $request->status;
            $event->updated_at = $update;

            if( $event->save() ){
                toastr()->success('Coupon Update Successfully');
                return redirect()->route('event-list');
            }
            else{
                toastr()->error('Something went wrong');
                return redirect()->route('event-list');
            }
        }

    }
}
