<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Store;
use App\Models\Subcategory;
use App\Models\Coupon;
use App\Models\Event;
use Illuminate\Support\Str;

class CouponController extends Controller
{
    public function couponView(){
    if(session()->get('id')!=null)
    {
        $page = request()->get('page', 1);
        $limit = request()->get('limit', 10);
    	$coupons = Coupon::leftjoin('categories','coupons.category_id','categories.id')
    					 ->leftjoin('sub_categories','coupons.sub_category_id','sub_categories.id')
    					 ->leftjoin('stores','coupons.store_id','stores.id')
    					 ->select('coupons.id','coupons.title','coupons.featured_image','categories.name as category_name','sub_categories.name as sub_category_name','stores.name as store_name')
    					 ->orderby('id','desc')->paginate($limit);
    	
    	return view('backend.pages.coupon.couponlist',get_defined_vars())->with('i', ($page - 1) * 5);
    }else{
        return redirect()->route('login');
    }
    }

    public function addCouponView(){
        if(session()->get('id')!=null)
    {
    	$cate = Category::select('categories.id','categories.name')->get();
        $event = Event::select('events.id','events.name')->get();
    	$store = Store::select('stores.id','stores.name')->orderby('name')->orderby('id','desc')->get();
    	return view('backend.pages.coupon.addcoupon',get_defined_vars());
    }else{
        return redirect()->route('login');
    }
    }

    public function addCoupon(Request $request){
    	$coupon = new Coupon;
    	$splitDate = explode(' - ', $request->expire);

    	$startdate = Str::replaceArray('/',['-','-'],$splitDate[0]);
    	$enddate = Str::replaceArray('/',['-','-'],$splitDate[1]);
    	
    	if($request->hasFile('file')){
    		$file = $request->file('file');
    		$image = uniqid().'.'.$file->guessExtension();
    		$image_path = $file->move(public_path().'/backend-asset/images/coupon/',$image);

    		$coupon->title = $request->title;
    		$coupon->description = $request->description;
    		$coupon->code = $request->code;
    		$coupon->type = $request->type;
    		$coupon->sale = $request->sale;
    		$coupon->total_use = $request->totaluse;
    		$coupon->url = $request->url;
            $coupon->exclusive = $request->exclusive;
    		$coupon->status = $request->status;
    		$coupon->featured_image = $image;
    		$coupon->category_id = $request->category;
    		$coupon->sub_category_id = $request->subcategory;
    		$coupon->store_id = $request->store;
            $coupon->event_id = $request->events;
    		$coupon->sorting_order = $request->sorting_order;
    		$coupon->start_date = $startdate;
    		$coupon->end_date = $enddate;


    		if( $coupon->save() ){
    			toastr()->success('Coupon Add Successfully');
    			return redirect()->route('coupons');
    		}
    		else{
    			toastr()->error('Something went wrong');
    			return redirect()->back();
    		}
    	}
    	else{
    		toastr()->error('Something went wrong in image');
    		return redirect()->back();
    	}
    }
    
    public function editCouponView($id){
        if(session()->get('id')!=null)
    {
        $coup = Coupon::where('id',$id)->first();
        $cate = Category::select('categories.id','categories.name')->get();
        $event = Event::select('events.id','events.name')->get();
    	$store = Store::select('stores.id','stores.name')->orderby('name')->orderby('id','desc')->get();

        return view('backend.pages.coupon.editcoupon',get_defined_vars());
    }else{
        return redirect()->route('login');
    }
    }


    public function editCouponPost(Request $request){
        
        $coupon = Coupon::find( $request->coupon_id );
        $splitDate = explode(' - ', $request->expire);

        $startdate = Str::replaceArray('/',['-','-'],$splitDate[0]);
        $enddate = Str::replaceArray('/',['-','-'],$splitDate[1]);
        $update = date('Y-m-d H:i:s');
        
        if($request->hasFile('file')){

            $file = $request->file('file');
            $image = uniqid().'.'.$file->guessExtension();
            $image_path = $file->move(public_path().'/backend-asset/images/coupon/',$image);

            $coupon->title = $request->title;
            $coupon->description = $request->description;
            $coupon->code = $request->code;
            $coupon->type = $request->type;
            $coupon->sale = $request->sale;
            $coupon->total_use = $request->totaluse;
            $coupon->url = $request->url;
            $coupon->exclusive = $request->exclusive;
            $coupon->status = $request->status;
            $coupon->featured_image = $image;
            $coupon->category_id = $request->category;
            $coupon->store_id = $request->store;
            $coupon->event_id = $request->events;
            $coupon->sorting_order = $request->sorting_order;
            $coupon->start_date = $startdate;
            $coupon->end_date = $enddate;
            $coupon->updated_at = $update;
            
            if( $coupon->save() ){
                toastr()->success('Coupon Update Successfully');
                return redirect()->route('coupons');
            }
            else{
                toastr()->error('Something went wrong');
                return redirect()->route('coupons');
            }
        }
        else{

            $coupon->title = $request->title;
            $coupon->description = $request->description;
            $coupon->code = $request->code;
            $coupon->type = $request->type;
            $coupon->sale = $request->sale;
            $coupon->total_use = $request->totaluse;
            $coupon->url = $request->url;
            $coupon->exclusive = $request->exclusive;
            $coupon->status = $request->status;
            $coupon->category_id = $request->category;
            $coupon->store_id = $request->store;
            $coupon->event_id = $request->events;
            $coupon->sorting_order = $request->sorting_order;
            $coupon->start_date = $startdate;
            $coupon->end_date = $enddate;
            $coupon->updated_at = $update;

            if( $coupon->save() ){
                toastr()->success('Coupon Update Successfully');
                return redirect()->route('coupons');
            }
            else{
                toastr()->error('Something went wrong');
                return redirect()->route('coupons');
            }
        }

    }

    public function subCategoryApi(Request $request){
    	$sub = Subcategory::where('category_id',$request->categoryid)->get();
    	return response()->json(['subcategory' => $sub]);
    }

    public function deleteCoupon($id){
        $coup = Coupon::find( $id );

        if( $coup->delete() ){
            toastr()->success("Delete Successfull");
            return redirect()->route('coupons');
        }
        else{
            toastr()->error("Something went wrong");
            return redirect()->route('coupons');
        }
    }

    public function check_sorting_order(Request $request){
        $check = Coupon::where('store_id',$request->store_id)->where('sorting_order',$request->sorting_order)->first();
        if(empty($check)){
            return response()->json(['data' => null, 'message' => 'Correct Number','success' => true]);
        }else{
            return response()->json(['data' => $check, 'message' => 'Already Taken','success' => false]);
        }
    }
    
    
     public function getcoupons(Request $request){
        if(!empty($request->key)){
          $store = Store::where('name','like', '%'.$request->key.'%')->first();
            $coupons = Coupon::leftjoin('categories','coupons.category_id','categories.id')
    					 ->leftjoin('sub_categories','coupons.sub_category_id','sub_categories.id')
    					 ->leftjoin('stores','coupons.store_id','stores.id')
    					 ->select('coupons.id','coupons.title','coupons.featured_image','coupons.code','coupons.url','categories.name as category_name','sub_categories.name as sub_category_name','stores.name as store_name')
    					 ->orderby('id','desc')->where('store_id',$store->id)->get();
            
           
            
            return view('backend.pages.autocomplete',compact('coupons'));
            
        }
    }

}
