<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Category;
use DB;
use Illuminate\Support\Str;

class CategoryController extends Controller
{
    public function categoryView(){
        if(session()->get('id')!=null)
    { 
    	$cate = Category::select('categories.id','categories.name','categories.slug','categories.feature_image')->orderBy('id')->get();;
    	return view('backend.pages.category.categorylist',compact('cate'));
    }else{
        return redirect()->route('login');
    }
    }

    public function categoryAdd(Request $request){
    if(session()->get('id')!=null)
    {
    	$cate = new Category;

    	if($request->hasFile('file')){

    		$file = $request->file('file');
	    	$image = uniqid().'.'.$file->guessExtension();
	    	$image_path = $file->move(public_path().'/backend-asset/images/category/',$image);

	    	$cate->name = $request->category_name;
	    	$cate->slug = Str::slug($request->category_name);
	    	$cate->meta_title = $request->metatitle;
	    	$cate->meta_description = $request->metadescription;
	    	$cate->feature_image = $image;

	    	if( $cate->save() ){
	    		toastr()->success('Category Add Successfully');
	    		return redirect()->route('category');
	    	}
	    	else{
	    		toastr()->error('Something went wrong');
	    		return redirect()->route('category');
	    	}
	    }
	    else{
	    	toastr()->error('Image Error');
	    		return redirect()->route('category');
	    }
    }else{
        return redirect()->route('login');
    }

    }

    public function editCategoryView($id){
        if(session()->get('id')!=null)
    {
    	$cate = Category::where('id',$id)->first();
    	return view('backend.pages.category.editcategory',compact('cate'));
    }else{
        return redirect()->route('login');
    }
    }

    public function editCategoryPost(Request $request){

    	$cate = Category::find( $request->category_id );

    	if($request->hasFile('file')){

    		$file = $request->file('file');
	    	$image = uniqid().'.'.$file->guessExtension();
	    	$image_path = $file->move(public_path().'/backend-asset/images/category/',$image);

	    	$cate->name = $request->category_name;
	    	$cate->slug = Str::slug($request->category_name);
	    	$cate->meta_title = $request->metatitle;
	    	$cate->meta_description = $request->metadescription;
	    	$cate->feature_image = $image;

	    	if( $cate->save() ){
	    		toastr()->success('Category Update Successfully');
	    		return redirect()->route('category');
	    	}
	    	else{
	    		toastr()->error('Something went wrong');
	    		return redirect()->route('category');
	    	}
	    }
	    else{

	    	$cate->name = $request->category_name;
	    	$cate->slug = Str::slug($request->category_name);
	    	$cate->meta_title = $request->metatitle;
	    	$cate->meta_description = $request->metadescription;

	    	if( $cate->save() ){
	    		toastr()->success('Category Update Successfully');
	    		return redirect()->route('category');
	    	}
	    	else{
	    		toastr()->error('Something went wrong');
	    		return redirect()->route('category');
	    	}
	    }

    }

    public function deleteCategory($id){
    	$cate = Category::find( $id );

    	if( $cate->delete() ){
	    	toastr()->success("Delete Successfull");
	    	return redirect()->route('category');
    	}
    	else{
    		toastr()->error("Something went wrong");
	    	return redirect()->route('category');
    	}
    }
}
