<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Blog;
use Illuminate\Support\Str;

class BlogController extends Controller
{
    public function blogView(){
        if(session()->get('id')!=null)
    {
    	$blogs = Blog::select('blogs.id','blogs.title','blogs.slug','blogs.featured_image')->get();
    	return view('backend.pages.blog.blog',get_defined_vars());
    }else{
        return redirect()->route('login');
    }
    }

    public function addBlogView(){
        if(session()->get('id')!=null)
    {
    	return view('backend.pages.blog.addblog');
    }else{
        return redirect()->route('login');
    }
    }

    public function addBlogPost(Request $request){
    	$blog = new Blog;

    	if($request->hasFile('file')){
    		$file = $request->file('file');
    		$image = uniqid().'.'.$file->guessExtension();
    		$image_path = $file->move(public_path().'/backend-asset/images/blog/',$image);

    		$blog->title = $request->title;
    		$blog->slug = Str::slug($request->title);
    		$blog->description = $request->description;
            $blog->meta_title = $request->metatitle;
            $blog->meta_description = $request->metadescription;
    		$blog->featured_image = $image;

    		if( $blog->save() ){
    			toastr()->success('Blog Add Successfully');
    			return redirect()->route('blogs');
    		}
    		else{
    			toastr()->error('Something went wrong');
    			return redirect()->back();
    		}
    	}
    	else{
    		toastr()->error('Something went wrong in image');
    		return redirect()->back();
    	}
    }


    public function editBlogView($id){
        $blog = Blog::where('id',$id)->first();
        return view('backend.pages.blog.editblog',compact('blog'));
    }

    public function editBlogPost(Request $request){

        $blog = Blog::find( $request->blog_id );

        if($request->hasFile('file')){

            $file = $request->file('file');
            $image = uniqid().'.'.$file->guessExtension();
            $image_path = $file->move(public_path().'/backend-asset/images/blog/',$image);

            $blog->title = $request->title;
            $blog->slug = Str::slug($request->title);
            $blog->description = $request->description;
            $blog->meta_title = $request->metatitle;
            $blog->meta_description = $request->metadescription;
            $blog->featured_image = $image;

            if( $blog->save() ){
                toastr()->success('Blog Update Successfully');
                return redirect()->route('blogs');
            }
            else{
                toastr()->error('Something went wrong');
                return redirect()->route('blogs');
            }
        }
        else{

            $blog->title = $request->title;
            $blog->slug = Str::slug($request->title);
            $blog->description = $request->description;
            $blog->meta_title = $request->metatitle;
            $blog->meta_description = $request->metadescription;

            if( $blog->save() ){
                toastr()->success('Blog Update Successfully');
                return redirect()->route('blogs');
            }
            else{
                toastr()->error('Something went wrong');
                return redirect()->route('blogs');
            }
        }

    }

    public function deleteBlog($id){
        $blog = Blog::find( $id );

        if( $blog->delete() ){
            toastr()->success("Delete Successfull");
            return redirect()->route('blogs');
        }
        else{
            toastr()->error("Something went wrong");
            return redirect()->route('blogs');
        }
    }
    
    public function blog_comments(){
        $comments = \DB::table('blog_comments')->select('*')->get();
        return view('backend.pages.blog.blog_comments',compact('comments'));
    }
    
    public function approve($id){
        $query = \DB::table('blog_comments')->where('id',$id)->update(array('status' => 1));
        toastr()->success('Approved Successfully');
        return back();
    }
}
